@extends('layouts.student')

@section('title', 'Certificate Details')
@section('page-title', 'Certificate Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('student.certificates.index') }}" class="btn btn-secondary">← Back to Certificates</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $certificate->title }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="text-align: center; margin-bottom: 40px;">
                @if($certificate->file_path)
                    <div style="background: #1a1a1a; padding: 30px; border-radius: 10px; margin-bottom: 30px;">
                        <img src="{{ asset('storage/' . $certificate->file_path) }}" alt="Certificate" style="max-width: 100%; height: auto; border-radius: 5px;">
                    </div>
                    <a href="{{ asset('storage/' . $certificate->file_path) }}" download class="btn btn-primary">
                        <i class="fas fa-download"></i> Download Certificate
                    </a>
                @else
                    <div style="padding: 60px; background: linear-gradient(135deg, #4a9eff 0%, #6bff6b 100%); border-radius: 10px; margin-bottom: 30px;">
                        <i class="fas fa-certificate" style="font-size: 120px; color: white; opacity: 0.9;"></i>
                    </div>
                @endif
            </div>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Certificate Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Certificate Title</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $certificate->title }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $certificate->course->name ?? 'N/A' }}</span>
                    </div>
                    @if($certificate->certificate_type)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Certificate Type</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ ucfirst($certificate->certificate_type) }}</span>
                    </div>
                    @endif
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Issuance Details</h4>
                    @if($certificate->issued_date)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Issued Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $certificate->issued_date->format('M d, Y') }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Recipient</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ auth()->user()->name }}</span>
                    </div>
                </div>
            </div>
            
            @if($certificate->description)
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Description</h4>
                <p style="color: #e0e0e0; line-height: 1.6;">{{ $certificate->description }}</p>
            </div>
            @endif
        </div>
    </div>
@endsection

