@extends('layouts.student')

@section('title', 'Certificates')
@section('page-title', 'My Certificates')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-certificate"></i> My Certificates</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($certificates->count() > 0)
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                    @foreach($certificates as $certificate)
                        <div class="card" style="padding: 0; overflow: hidden; cursor: pointer;" onclick="window.location='{{ route('student.certificates.show', $certificate->id) }}';" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 25px rgba(74, 158, 255, 0.3)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 20px rgba(0,0,0,0.5)';" style="transition: all 0.3s;">
                            <div style="padding: 30px; text-align: center; background: linear-gradient(135deg, #4a9eff 0%, #6bff6b 100%);">
                                <i class="fas fa-certificate" style="font-size: 64px; color: white; opacity: 0.9;"></i>
                            </div>
                            <div style="padding: 20px;">
                                <h4 style="color: #e0e0e0; margin-bottom: 10px; font-size: 16px;">{{ $certificate->title }}</h4>
                                <p style="color: #888; font-size: 13px; margin-bottom: 8px;">{{ $certificate->course->name ?? 'N/A' }}</p>
                                @if($certificate->issued_date)
                                <p style="color: #888; font-size: 12px; margin-bottom: 15px;">
                                    <i class="fas fa-calendar"></i> Issued: {{ $certificate->issued_date->format('M d, Y') }}
                                </p>
                                @endif
                                <a href="{{ route('student.certificates.show', $certificate->id) }}" class="btn btn-primary" style="width: 100%; padding: 8px; font-size: 13px;">
                                    <i class="fas fa-eye"></i> View Certificate
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-certificate" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>You haven't earned any certificates yet.</p>
                    <p style="font-size: 14px; margin-top: 10px;">Complete your courses to earn certificates!</p>
                </div>
            @endif
        </div>
    </div>
@endsection

