@extends('layouts.student')

@section('title', $book->title)

@section('content')
<div class="content-area">
    <div class="card">
        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 30px; flex-wrap: wrap; gap: 20px;">
            <div style="flex: 1;">
                <h2 style="color: #4a9eff; margin-bottom: 10px; font-size: 24px;">{{ $book->title }}</h2>
                @if($book->author)
                    <p style="color: #888; margin-bottom: 5px;"><i class="fas fa-user"></i> {{ $book->author }}</p>
                @endif
                @if($book->description)
                    <p style="color: #aaa; line-height: 1.6; margin-top: 15px;">{{ $book->description }}</p>
                @endif
            </div>
            @if($book->cover_image)
                <img src="{{ asset($book->cover_image) }}" alt="{{ $book->title }}" style="width: 150px; height: 200px; object-fit: cover; border-radius: 8px; border: 1px solid #404040;">
            @endif
        </div>

        <!-- Progress Bar -->
        <div style="background: #1a1a1a; padding: 15px; border-radius: 8px; margin-bottom: 30px; border: 1px solid #404040;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                <span style="color: #4a9eff; font-weight: 600;"><i class="fas fa-chart-line"></i> Reading Progress</span>
                <span style="color: #888; font-size: 14px;">{{ number_format($overallProgress, 1) }}%</span>
            </div>
            <div style="background: #2d2d2d; height: 8px; border-radius: 4px; overflow: hidden;">
                <div style="background: linear-gradient(90deg, #4a9eff 0%, #3a8eef 100%); height: 100%; width: {{ $overallProgress }}%; transition: width 0.3s;"></div>
            </div>
        </div>

        <!-- Chapters List -->
        <div class="card-header">
            <h3><i class="fas fa-list"></i> Table of Contents ({{ $book->chapters->count() }} Chapters)</h3>
        </div>

        <div style="margin-top: 20px;">
            @foreach($book->chapters as $chapter)
                @php
                    $chapterProgress = $progress->get($chapter->id);
                    $isCompleted = $chapterProgress && $chapterProgress->is_completed;
                @endphp
                <div class="chapter-item" style="background: #1a1a1a; border: 1px solid #404040; border-radius: 8px; padding: 20px; margin-bottom: 15px; transition: all 0.3s; position: relative;">
                    <div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
                        <div style="flex: 1;">
                            <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 10px;">
                                <span style="background: #4a9eff; color: white; width: 35px; height: 35px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 14px;">
                                    {{ $chapter->chapter_number }}
                                </span>
                                <h4 style="color: #e0e0e0; font-size: 16px; margin: 0; font-weight: 500;">{{ $chapter->title }}</h4>
                                @if($isCompleted)
                                    <span style="background: #28a745; color: white; padding: 4px 10px; border-radius: 5px; font-size: 12px; font-weight: 500;">
                                        <i class="fas fa-check"></i> Completed
                                    </span>
                                @endif
                            </div>
                            @if($chapter->description)
                                <p style="color: #888; font-size: 14px; margin-left: 50px; margin-bottom: 0;">{{ $chapter->description }}</p>
                            @endif
                        </div>
                        <a href="{{ route('student.books.chapters.read', ['book' => $book->id, 'chapter' => $chapter->id]) }}" 
                           class="btn btn-primary" 
                           style="text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                            <i class="fas fa-book-reader"></i> {{ $isCompleted ? 'Review' : 'Read' }}
                        </a>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Bookmarks Section -->
        @if($bookmarks->count() > 0)
            <div class="card-header" style="margin-top: 40px;">
                <h3><i class="fas fa-bookmark"></i> Your Bookmarks</h3>
            </div>
            <div style="margin-top: 20px;">
                @foreach($bookmarks as $bookmark)
                    <div style="background: #1a1a1a; border: 1px solid #404040; border-radius: 8px; padding: 15px; margin-bottom: 10px;">
                        <div style="display: flex; justify-content: space-between; align-items: start;">
                            <div style="flex: 1;">
                                <h5 style="color: #4a9eff; margin-bottom: 5px; font-size: 14px;">
                                    <i class="fas fa-bookmark" style="color: #ffc107;"></i> {{ $bookmark->title ?? 'Bookmark' }}
                                </h5>
                                <p style="color: #888; font-size: 12px; margin-bottom: 5px;">
                                    Chapter {{ $bookmark->chapter->chapter_number }}: {{ $bookmark->chapter->title }}
                                </p>
                                @if($bookmark->note)
                                    <p style="color: #aaa; font-size: 13px; margin: 0;">{{ $bookmark->note }}</p>
                                @endif
                            </div>
                            <a href="{{ route('student.books.chapters.read', ['book' => $book->id, 'chapter' => $bookmark->chapter->id]) }}?position={{ $bookmark->position }}" 
                               class="btn btn-secondary" 
                               style="text-decoration: none; padding: 6px 12px; font-size: 12px;">
                                Go to
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>

<style>
    .chapter-item:hover {
        border-color: #4a9eff;
        transform: translateX(5px);
    }
</style>
@endsection

