<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $chapter->title }} - {{ $book->title }}</title>
    <style>
        @page {
            margin: 2cm;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            color: #2c3e50;
            line-height: 1.6;
            font-size: 11pt;
        }

        .pdf-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #4a9eff;
        }

        .pdf-header .book-title {
            font-size: 16pt;
            color: #4a9eff;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .pdf-header .chapter-title {
            font-size: 20pt;
            color: #2c3e50;
            font-weight: 700;
            margin-bottom: 10px;
        }

        .pdf-header .chapter-meta {
            font-size: 10pt;
            color: #666;
            font-style: italic;
        }

        .pdf-content {
            color: #2c3e50;
        }

        .pdf-content h1 {
            font-size: 18pt;
            color: #2c3e50;
            margin: 20px 0 15px 0;
            font-weight: 700;
            page-break-after: avoid;
        }

        .pdf-content h2 {
            font-size: 16pt;
            color: #2c3e50;
            margin: 18px 0 12px 0;
            font-weight: 700;
            page-break-after: avoid;
        }

        .pdf-content h3 {
            font-size: 14pt;
            color: #4a9eff;
            margin: 15px 0 10px 0;
            font-weight: 600;
            page-break-after: avoid;
        }

        .pdf-content h4 {
            font-size: 12pt;
            color: #4a9eff;
            margin: 12px 0 8px 0;
            font-weight: 600;
        }

        .pdf-content p {
            margin-bottom: 12px;
            text-align: justify;
        }

        .pdf-content ul,
        .pdf-content ol {
            margin: 12px 0 12px 25px;
            page-break-inside: avoid;
        }

        .pdf-content li {
            margin-bottom: 8px;
        }

        .pdf-content code {
            background: #f5f5f5;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 10pt;
            color: #2c3e50;
        }

        .pdf-content pre {
            background: #f5f5f5;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
            overflow-x: auto;
            page-break-inside: avoid;
            font-family: 'Courier New', monospace;
            font-size: 9pt;
        }

        .pdf-content pre code {
            background: transparent;
            padding: 0;
        }

        .pdf-content table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            page-break-inside: avoid;
        }

        .pdf-content table th {
            background: #4a9eff;
            color: white;
            padding: 10px;
            text-align: left;
            font-weight: 600;
            font-size: 10pt;
        }

        .pdf-content table td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 10pt;
        }

        .pdf-content table tr:nth-child(even) {
            background: #f9f9f9;
        }

        .pdf-content .section-header {
            display: flex;
            align-items: baseline;
            gap: 10px;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }

        .pdf-content .section-number {
            font-size: 16pt;
            font-weight: 700;
            color: #4a9eff;
        }

        .pdf-content .section-heading {
            font-size: 18pt;
            color: #2c3e50;
            font-weight: 700;
        }

        .pdf-content .learning-objectives-section {
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin: 20px 0;
            page-break-inside: avoid;
        }

        .pdf-content .objectives-list {
            list-style: none;
            padding: 0;
        }

        .pdf-content .objectives-list li {
            padding: 8px 0 8px 25px;
            position: relative;
        }

        .pdf-content .objectives-list li:before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #4a9eff;
            font-weight: bold;
        }

        .pdf-content .approach-card,
        .pdf-content .concept-box {
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
            page-break-inside: avoid;
        }

        .pdf-content .assignment-box {
            background: #fff3cd;
            border: 2px solid #ffc107;
            border-radius: 5px;
            padding: 20px;
            margin: 20px 0;
            page-break-inside: avoid;
        }

        .pdf-content .assignment-box h3 {
            color: #856404;
            margin-bottom: 10px;
        }

        .pdf-content blockquote {
            border-left: 4px solid #4a9eff;
            padding-left: 15px;
            margin: 15px 0;
            color: #666;
            font-style: italic;
        }

        .pdf-content img {
            max-width: 100%;
            height: auto;
            margin: 15px 0;
            page-break-inside: avoid;
        }

        .pdf-content a {
            color: #4a9eff;
            text-decoration: none;
        }

        .pdf-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 9pt;
            color: #666;
            padding: 10px;
            border-top: 1px solid #ddd;
        }

        .page-number:after {
            content: "Page " counter(page);
        }

        @media print {
            .pdf-content {
                page-break-after: auto;
            }

            .pdf-content h1,
            .pdf-content h2,
            .pdf-content h3 {
                page-break-after: avoid;
            }

            .pdf-content pre,
            .pdf-content table,
            .pdf-content img {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="pdf-header">
        <div class="book-title">{{ $book->title }}</div>
        <div class="chapter-title">{{ $chapter->title }}</div>
        @if($book->author)
            <div class="chapter-meta">By {{ $book->author }}</div>
        @endif
        <div class="chapter-meta">Chapter {{ $chapter->chapter_number }}</div>
    </div>

    <div class="pdf-content">
        {!! $chapterContent !!}
    </div>

    <div class="pdf-footer">
        <div class="page-number"></div>
        <div style="margin-top: 5px;">{{ $book->title }} - {{ $chapter->title }} | Generated on {{ now()->format('F d, Y') }}</div>
    </div>
</body>
</html>

