@extends('layouts.student')

@section('title', 'Books')

@section('content')
<div class="content-area">
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-book"></i> Available Books</h3>
        </div>

        @if($books->isEmpty())
            <div style="text-align: center; padding: 40px; color: #888;">
                <i class="fas fa-book-open" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                <p>No books available at the moment.</p>
            </div>
        @else
            <div class="books-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 25px; margin-top: 20px;">
                @foreach($books as $book)
                    <div class="book-card" style="background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%); border: 1px solid #404040; border-radius: 12px; padding: 25px; transition: all 0.3s; cursor: pointer; position: relative; overflow: hidden;">
                        <a href="{{ route('student.books.show', $book) }}" style="text-decoration: none; color: inherit; display: block;">
                            <div style="position: relative; margin-bottom: 20px;">
                                @if($book->cover_image)
                                    <img src="{{ asset($book->cover_image) }}" alt="{{ $book->title }}" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; border: 1px solid #404040;">
                                @else
                                    <div style="width: 100%; height: 200px; background: linear-gradient(135deg, #4a9eff 0%, #3a8eef 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-book" style="font-size: 64px; color: white; opacity: 0.8;"></i>
                                    </div>
                                @endif
                                <div style="position: absolute; top: 10px; right: 10px; background: rgba(0,0,0,0.7); padding: 5px 10px; border-radius: 5px; font-size: 12px; color: #4a9eff;">
                                    <i class="fas fa-book-open"></i> {{ $book->chapters->count() }} Chapters
                                </div>
                            </div>
                            
                            <h4 style="color: #4a9eff; font-size: 18px; margin-bottom: 10px; font-weight: 600;">{{ $book->title }}</h4>
                            
                            @if($book->author)
                                <p style="color: #888; font-size: 13px; margin-bottom: 10px;">
                                    <i class="fas fa-user"></i> {{ $book->author }}
                                </p>
                            @endif
                            
                            @if($book->description)
                                <p style="color: #aaa; font-size: 14px; line-height: 1.5; margin-bottom: 15px; display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden;">
                                    {{ $book->description }}
                                </p>
                            @endif
                            
                            <div style="display: flex; align-items: center; justify-content: space-between; margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
                                <span style="color: #888; font-size: 12px;">
                                    <i class="fas fa-clock"></i> Last updated {{ $book->updated_at->diffForHumans() }}
                                </span>
                                <span style="color: #4a9eff; font-size: 14px; font-weight: 500;">
                                    Read <i class="fas fa-arrow-right"></i>
                                </span>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>

<style>
    .book-card:hover {
        transform: translateY(-5px);
        border-color: #4a9eff;
        box-shadow: 0 8px 30px rgba(74, 158, 255, 0.3);
    }

    @media (max-width: 768px) {
        .books-grid {
            grid-template-columns: 1fr !important;
        }
    }
</style>
@endsection

