@extends('layouts.student')

@section('title', 'Assignment Details')
@section('page-title', 'Assignment Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('student.assignments.index') }}" class="btn btn-secondary">← Back to Assignments</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $assignment->title }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Assignment Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $assignment->course->name }}</span>
                    </div>
                    @if($assignment->chapter)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Chapter</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $assignment->chapter->title }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Points</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ number_format($assignment->total_points, 0) }} points</span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Due Date & Status</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Due Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">
                            {{ $assignment->due_date->format('M d, Y') }}
                            @if($assignment->due_time)
                                at {{ date('h:i A', strtotime($assignment->due_time)) }}
                            @endif
                        </span>
                        @php
                            $dueDateTime = $assignment->due_date;
                            if ($assignment->due_time) {
                                $dueTimeStr = is_string($assignment->due_time) ? $assignment->due_time : (is_object($assignment->due_time) ? $assignment->due_time->format('H:i') : $assignment->due_time);
                                $dueDateTime = \Carbon\Carbon::parse($assignment->due_date->format('Y-m-d') . ' ' . $dueTimeStr);
                            } else {
                                $dueDateTime = $assignment->due_date->endOfDay();
                            }
                            $isPastDue = \Carbon\Carbon::now()->greaterThan($dueDateTime);
                        @endphp
                        @if($isPastDue && (!$submission || $submission->status != 'submitted'))
                            <span style="color: #ff6b6b; font-size: 14px; display: block; margin-top: 5px;">⚠ Past Due</span>
                        @endif
                    </div>
                    @if($submission)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Submission Status</strong>
                        @if($submission->status == 'graded')
                            <span style="color: #6bff6b; font-size: 16px;">Graded</span>
                            <div style="margin-top: 5px;">
                                <span style="color: #e0e0e0; font-size: 18px; font-weight: 600;">
                                    Score: {{ number_format($submission->score, 1) }} / {{ number_format($assignment->total_points, 1) }}
                                </span>
                                <span style="color: #888; font-size: 14px;">
                                    ({{ number_format($submission->grade_percentage, 1) }}%)
                                </span>
                            </div>
                        @else
                            <span style="color: #ffc107; font-size: 16px;">Submitted</span>
                        @endif
                    </div>
                    @endif
                </div>
            </div>
            
            @if($assignment->description)
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Description</h4>
                <p style="color: #e0e0e0; line-height: 1.6;">{{ $assignment->description }}</p>
            </div>
            @endif
            
            @if($assignment->instructions)
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Instructions</h4>
                <div style="color: #e0e0e0; line-height: 1.6; white-space: pre-wrap;">{{ $assignment->instructions }}</div>
            </div>
            @endif
            
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div style="margin-top: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> {{ session('success') }}
                </div>
            @endif
            
            @if($errors->any())
                <div style="margin-top: 20px; padding: 15px; background: #4d1a1a; border: 1px solid #ff6b6b; border-radius: 5px; color: #ff6b6b;">
                    <strong>Error:</strong>
                    <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <!-- Submission Section -->
            @if(!$submission || ($submission->status == 'draft' || $submission->status == 'submitted'))
            <div style="margin-top: 30px; padding-top: 30px; border-top: 2px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 20px;">
                    @if($submission && $submission->status == 'submitted')
                        Update Submission
                    @else
                        Submit Assignment
                    @endif
                </h4>
                <form method="POST" action="{{ route('student.assignments.submit', $assignment->id) }}" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label for="submission_text">Your Submission</label>
                        <textarea 
                            id="submission_text" 
                            name="submission_text" 
                            rows="8"
                            placeholder="Write your submission here or paste your code/response..."
                        >{{ old('submission_text', $submission->submission_text ?? '') }}</textarea>
                        @error('submission_text')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="submission_file">Upload File (Optional)</label>
                        <input 
                            type="file" 
                            id="submission_file" 
                            name="submission_file"
                            accept=".pdf,.doc,.docx,.zip,.rar"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Maximum file size: 10MB. Supported formats: PDF, DOC, DOCX, ZIP, RAR</small>
                        @error('submission_file')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> Submit Assignment
                        </button>
                    </div>
                </form>
            </div>
            @else
            <!-- View Submission -->
            <div style="margin-top: 30px; padding-top: 30px; border-top: 2px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 20px;">Your Submission</h4>
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Submitted On</strong>
                    <span style="color: #e0e0e0;">
                        {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y h:i A') : 'N/A' }}
                        @if($submission->is_late)
                            <span style="color: #ff6b6b;">(Late)</span>
                        @endif
                    </span>
                </div>
                
                @if($submission->submission_text)
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Your Answer</strong>
                    <div style="color: #e0e0e0; padding: 15px; background: #1a1a1a; border-radius: 5px; white-space: pre-wrap;">{{ $submission->submission_text }}</div>
                </div>
                @endif
                
                @if($submission->submission_file)
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Attached File</strong>
                    <a href="{{ asset('storage/' . $submission->submission_file) }}" target="_blank" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                        <i class="fas fa-download"></i> Download File
                    </a>
                </div>
                @endif
                
                @if($submission->status == 'graded')
                <div style="margin-top: 30px; padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                    <h5 style="color: #4a9eff; margin-bottom: 15px;">Grade & Feedback</h5>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Score</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">
                            {{ number_format($submission->score, 1) }} / {{ number_format($assignment->total_points, 1) }}
                        </span>
                        <span style="color: #888; font-size: 14px;">
                            ({{ number_format($submission->grade_percentage, 1) }}%)
                        </span>
                    </div>
                    @if($submission->instructor_feedback)
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Instructor Feedback</strong>
                        <div style="color: #e0e0e0; padding: 15px; background: #2d2d2d; border-radius: 5px; white-space: pre-wrap;">{{ $submission->instructor_feedback }}</div>
                    </div>
                    @endif
                </div>
                @endif
            </div>
            @endif
        </div>
    </div>
@endsection

