@extends('layouts.student')

@section('title', 'Assignments')
@section('page-title', 'My Assignments')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tasks"></i> My Assignments</h3>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('student.assignments.index') }}" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>{{ $course->name }}</option>
                    @endforeach
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="submitted" {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                    <option value="graded" {{ request('status') == 'graded' ? 'selected' : '' }}>Graded</option>
                    <option value="overdue" {{ request('status') == 'overdue' ? 'selected' : '' }}>Overdue</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request()->anyFilled(['course_id', 'status']))
                    <a href="{{ route('student.assignments.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($assignments->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Assignment</th>
                            <th>Course</th>
                            <th>Due Date</th>
                            <th>Points</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($assignments as $assignment)
                            @php
                                $submission = $assignment->submissions->first();
                                $isSubmitted = $submission && in_array($submission->status, ['submitted', 'graded']);
                                $isPastDue = $assignment->due_date < now()->toDateString() && !$isSubmitted;
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $assignment->title }}</strong>
                                    @if($assignment->chapter)
                                        <br><small style="color: #888;">Chapter: {{ $assignment->chapter->title }}</small>
                                    @endif
                                </td>
                                <td>{{ $assignment->course->name }}</td>
                                <td>
                                    {{ $assignment->due_date->format('M d, Y') }}
                                    @if($assignment->due_time)
                                        <br><small style="color: #888;">{{ date('h:i A', strtotime($assignment->due_time)) }}</small>
                                    @endif
                                    @if($isPastDue)
                                        <br><span style="color: #ff6b6b; font-size: 11px;">⚠ Overdue</span>
                                    @endif
                                </td>
                                <td>{{ number_format($assignment->total_points, 0) }} pts</td>
                                <td>
                                    @if($submission && $submission->status == 'graded')
                                        <span style="color: #6bff6b;">Graded</span>
                                        <br><small style="color: #888;">Score: {{ number_format($submission->score, 1) }}/{{ number_format($assignment->total_points, 1) }}</small>
                                    @elseif($isSubmitted)
                                        <span style="color: #ffc107;">Submitted</span>
                                    @elseif($isPastDue)
                                        <span style="color: #ff6b6b;">Overdue</span>
                                    @else
                                        <span style="color: #888;">Pending</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('student.assignments.show', $assignment->id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div style="margin-top: 20px;">{{ $assignments->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-tasks" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No assignments found.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

