@if(isset($studentOutstandingBalance) && $studentOutstandingBalance > 0)
<!-- Balance Reminder Modal -->
<div id="balanceReminderModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%); border-radius: 12px; padding: 30px; max-width: 500px; width: 90%; box-shadow: 0 10px 40px rgba(0,0,0,0.8); border: 2px solid #ff6b6b; position: relative; animation: modalSlideIn 0.3s ease-out;">
        <!-- Close Button -->
        <button onclick="closeBalanceReminder()" style="position: absolute; top: 15px; right: 15px; background: transparent; border: none; color: #888; font-size: 24px; cursor: pointer; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center; border-radius: 50%; transition: all 0.3s;" onmouseover="this.style.background='#404040'; this.style.color='#e0e0e0';" onmouseout="this.style.background='transparent'; this.style.color='#888';">
            <i class="fas fa-times"></i>
        </button>
        
        <!-- Icon -->
        <div style="text-align: center; margin-bottom: 20px;">
            <div style="width: 80px; height: 80px; border-radius: 50%; background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); display: flex; align-items: center; justify-content: center; margin: 0 auto; box-shadow: 0 4px 20px rgba(255, 107, 107, 0.4);">
                <i class="fas fa-exclamation-triangle" style="font-size: 40px; color: white;"></i>
            </div>
        </div>
        
        <!-- Title -->
        <h2 style="color: #e0e0e0; text-align: center; margin-bottom: 15px; font-size: 24px; font-weight: 600;">
            Payment Reminder
        </h2>
        
        <!-- Message -->
        <p style="color: #888; text-align: center; margin-bottom: 25px; line-height: 1.6; font-size: 15px;">
            You have an outstanding balance that needs to be settled. Please make payment to continue enjoying uninterrupted access to your courses.
        </p>
        
        <!-- Balance Display -->
        <div style="background: #1a1a1a; border-radius: 8px; padding: 20px; margin-bottom: 25px; border: 1px solid #404040;">
            <div style="text-align: center;">
                <div style="color: #888; font-size: 14px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px;">Outstanding Balance</div>
                <div style="color: #ff6b6b; font-size: 36px; font-weight: 700; margin-bottom: 5px;">
                    ₵{{ number_format($studentOutstandingBalance, 2) }}
                </div>
                @if(isset($studentFeeAlerts) && count($studentFeeAlerts) > 0)
                    <div style="color: #888; font-size: 12px;">
                        Across {{ count($studentFeeAlerts) }} {{ count($studentFeeAlerts) == 1 ? 'course' : 'courses' }}
                    </div>
                @endif
            </div>
        </div>
        
        <!-- Course Breakdown (if multiple) -->
        @if(isset($studentFeeAlerts) && count($studentFeeAlerts) > 0 && count($studentFeeAlerts) <= 3)
            <div style="margin-bottom: 25px;">
                <div style="color: #888; font-size: 12px; margin-bottom: 10px; text-transform: uppercase; letter-spacing: 1px;">Breakdown:</div>
                @foreach($studentFeeAlerts as $alert)
                    <div style="display: flex; justify-content: space-between; padding: 10px; background: #1a1a1a; border-radius: 5px; margin-bottom: 8px; border: 1px solid #404040;">
                        <span style="color: #e0e0e0; font-size: 13px;">{{ $alert['course']->title }}</span>
                        <span style="color: #ff6b6b; font-weight: 600; font-size: 13px;">₵{{ number_format($alert['balance'], 2) }}</span>
                    </div>
                @endforeach
            </div>
        @endif
        
        <!-- Action Buttons -->
        <div style="display: flex; gap: 10px;">
            <button onclick="closeBalanceReminder()" style="flex: 1; padding: 12px; background: #404040; color: #e0e0e0; border: none; border-radius: 6px; cursor: pointer; font-size: 14px; font-weight: 500; transition: all 0.3s;" onmouseover="this.style.background='#505050';" onmouseout="this.style.background='#404040';">
                <i class="fas fa-times"></i> Remind Me Later
            </button>
            <a href="{{ route('student.profile.index') }}" style="flex: 1; padding: 12px; background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 14px; font-weight: 500; text-align: center; text-decoration: none; display: flex; align-items: center; justify-content: center; gap: 8px; transition: all 0.3s; box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 20px rgba(255, 107, 107, 0.4)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(255, 107, 107, 0.3)';">
                <i class="fas fa-credit-card"></i> View Details
            </a>
        </div>
    </div>
</div>

<style>
    @keyframes modalSlideIn {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(0.95);
        }
        to {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }
</style>

<script>
    // Check if reminder should be shown
    function shouldShowBalanceReminder() {
        // Check last shown time (show randomly, but not more than once per hour)
        const lastShown = localStorage.getItem('balanceReminderLastShown');
        if (lastShown) {
            const lastShownTime = parseInt(lastShown);
            const now = Date.now();
            const oneHour = 60 * 60 * 1000; // 1 hour in milliseconds
            
            // If shown less than an hour ago, don't show
            if (now - lastShownTime < oneHour) {
                return false;
            }
        }
        
        // Random chance: 25% chance to show (adjust as needed)
        // This means it will show approximately once every 4 page visits (on average)
        const randomChance = Math.random();
        return randomChance < 0.25; // 25% chance
    }
    
    // Show balance reminder modal
    function showBalanceReminder() {
        const modal = document.getElementById('balanceReminderModal');
        if (modal && shouldShowBalanceReminder()) {
            modal.style.display = 'flex';
            // Record that we showed it
            localStorage.setItem('balanceReminderLastShown', Date.now().toString());
        }
    }
    
    // Close balance reminder modal
    function closeBalanceReminder() {
        const modal = document.getElementById('balanceReminderModal');
        if (modal) {
            modal.style.display = 'none';
        }
    }
    
    // Show reminder after page loads (with a slight delay for better UX)
    document.addEventListener('DOMContentLoaded', function() {
        // Wait 3-8 seconds before showing (random delay for natural feel)
        const delay = Math.random() * 5000 + 3000; // 3-8 seconds
        setTimeout(function() {
            showBalanceReminder();
        }, delay);
    });
    
    // Close on outside click
    document.addEventListener('click', function(e) {
        const modal = document.getElementById('balanceReminderModal');
        if (modal && e.target === modal) {
            closeBalanceReminder();
        }
    });
    
    // Close on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            const modal = document.getElementById('balanceReminderModal');
            if (modal && modal.style.display === 'flex') {
                closeBalanceReminder();
            }
        }
    });
</script>
@endif

