@php
    $layout = 'layouts.' . auth()->user()->role;
@endphp

@extends($layout)

@section('title', 'Notification Details')
@section('page-title', 'Notification Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('notifications.index') }}" class="btn btn-secondary">← Back to Notifications</a>
    </div>
    
    <div class="card">
        <div style="padding: 30px;">
            <div style="margin-bottom: 20px;">
                <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 15px;">
                    @if(!$notification->is_read)
                        <span style="width: 12px; height: 12px; background: #4a9eff; border-radius: 50%; display: inline-block;"></span>
                    @endif
                    <h2 style="color: #e0e0e0; margin: 0; font-size: 24px;">{{ $notification->title }}</h2>
                    <span style="padding: 6px 12px; border-radius: 4px; font-size: 12px; background: {{ $notification->priority == 'urgent' ? '#dc3545' : ($notification->priority == 'high' ? '#ff6b6b' : ($notification->priority == 'normal' ? '#4a9eff' : '#888')) }}; color: white; text-transform: uppercase;">
                        {{ $notification->priority }}
                    </span>
                </div>
                
                <div style="display: flex; align-items: center; gap: 20px; color: #888; font-size: 14px; margin-bottom: 30px;">
                    @if($notification->sender)
                        <span><i class="fas fa-user"></i> From: <strong style="color: #e0e0e0;">{{ $notification->sender->name }}</strong></span>
                    @endif
                    <span><i class="fas fa-clock"></i> {{ $notification->created_at->format('M d, Y h:i A') }}</span>
                    @if($notification->email_sent)
                        <span style="color: #6bff6b;"><i class="fas fa-envelope"></i> Email sent</span>
                    @endif
                </div>
            </div>
            
            <div style="background: #1a1a1a; padding: 25px; border-radius: 8px; border-left: 4px solid #4a9eff;">
                <div style="color: #e0e0e0; font-size: 16px; line-height: 1.8; white-space: pre-wrap;">
                    {!! nl2br(e($notification->message)) !!}
                </div>
            </div>
            
            <div style="margin-top: 30px; display: flex; gap: 10px;">
                @if(!$notification->is_read)
                    <form action="{{ route('notifications.mark-read', $notification->id) }}" method="POST" style="margin: 0;">
                        @csrf
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check"></i> Mark as Read
                        </button>
                    </form>
                @endif
                
                <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST" style="margin: 0;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" onclick="return confirm('Are you sure you want to delete this notification?')" class="btn btn-secondary">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection

