@php
    $layout = 'layouts.' . auth()->user()->role;
@endphp

@extends($layout)

@section('title', 'Notifications')
@section('page-title', 'Notifications')

@section('content')
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h3 style="margin: 0; color: #e0e0e0;"><i class="fas fa-bell"></i> My Notifications</h3>
        @if($notifications->where('is_read', false)->count() > 0)
            <form action="{{ route('notifications.mark-all-read') }}" method="POST" style="margin: 0;">
                @csrf
                <button type="submit" class="btn btn-secondary">
                    <i class="fas fa-check-double"></i> Mark All as Read
                </button>
            </form>
        @endif
    </div>
    
    @if($notifications->count() > 0)
        <div class="card" style="padding: 0;">
            <div style="display: flex; flex-direction: column;">
                @foreach($notifications as $notification)
                    <a href="{{ route('notifications.show', $notification->id) }}" style="text-decoration: none; display: block; border-bottom: 1px solid #404040;" onmouseover="this.style.background='#1a1a1a';" onmouseout="this.style.background='transparent';">
                        <div style="padding: 20px 30px;">
                            <div style="display: flex; justify-content: space-between; align-items: start; gap: 15px;">
                                <div style="flex: 1;">
                                    <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 8px;">
                                        @if(!$notification->is_read)
                                            <span style="width: 10px; height: 10px; background: #4a9eff; border-radius: 50%; display: inline-block;"></span>
                                        @endif
                                        <strong style="color: #e0e0e0; font-size: 16px;">{{ $notification->title }}</strong>
                                        <span style="padding: 4px 10px; border-radius: 4px; font-size: 11px; background: {{ $notification->priority == 'urgent' ? '#dc3545' : ($notification->priority == 'high' ? '#ff6b6b' : ($notification->priority == 'normal' ? '#4a9eff' : '#888')) }}; color: white; text-transform: uppercase;">
                                            {{ $notification->priority }}
                                        </span>
                                    </div>
                                    <p style="color: #888; font-size: 14px; margin: 0 0 10px 0; line-height: 1.6;">
                                        {{ \Str::limit($notification->message, 200) }}
                                    </p>
                                    <div style="display: flex; align-items: center; gap: 15px; font-size: 12px; color: #666;">
                                        @if($notification->sender)
                                            <span><i class="fas fa-user"></i> From: {{ $notification->sender->name }}</span>
                                        @endif
                                        <span><i class="fas fa-clock"></i> {{ $notification->created_at ? $notification->created_at->format('M d, Y h:i A') : 'N/A' }}</span>
                                        @if($notification->email_sent)
                                            <span style="color: #6bff6b;"><i class="fas fa-envelope"></i> Email sent</span>
                                        @endif
                                    </div>
                                </div>
                                <div style="text-align: right;">
                                    <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST" onclick="event.stopPropagation();" style="display: inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this notification?')" style="background: transparent; border: none; color: #888; cursor: pointer; padding: 5px; font-size: 14px;" onmouseover="this.style.color='#ff6b6b';" onmouseout="this.style.color='#888';">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
        
        <div style="margin-top: 20px;">
            {{ $notifications->links() }}
        </div>
    @else
        <div class="card">
            <div style="text-align: center; padding: 60px 20px; color: #888;">
                <i class="fas fa-bell-slash" style="font-size: 64px; margin-bottom: 20px; opacity: 0.5;"></i>
                <p style="font-size: 18px; margin: 0;">No notifications yet</p>
                <p style="font-size: 14px; margin-top: 10px;">You'll see announcements and updates here when they're sent.</p>
            </div>
        </div>
    @endif
@endsection

