<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Afrilen Technologies') }} - Instructor @yield('title', 'Dashboard')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Styles -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Figtree', sans-serif;
            background: #1a1a1a;
            color: #e0e0e0;
            min-height: 100vh;
        }
        
        .instructor-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 260px;
            background: #2d2d2d;
            border-right: 1px solid #404040;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid #404040;
        }
        
        .sidebar-header h1 {
            color: #4a9eff;
            font-size: 20px;
            margin-bottom: 5px;
        }
        
        .sidebar-header p {
            color: #888;
            font-size: 12px;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-item {
            display: block;
            padding: 12px 20px;
            color: #e0e0e0;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover {
            background: #1a1a1a;
            color: #4a9eff;
            border-left-color: #4a9eff;
        }
        
        .menu-item.active {
            background: #1a1a1a;
            color: #4a9eff;
            border-left-color: #4a9eff;
            font-weight: 500;
        }
        
        .menu-section {
            padding: 10px 20px;
            font-size: 11px;
            text-transform: uppercase;
            color: #888;
            font-weight: 600;
            letter-spacing: 1px;
        }
        
        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 260px;
            display: flex;
            flex-direction: column;
        }
        
        /* Top Bar */
        .top-bar {
            background: #2d2d2d;
            padding: 15px 30px;
            border-bottom: 1px solid #404040;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .top-bar h2 {
            color: #e0e0e0;
            font-size: 18px;
            font-weight: 500;
        }
        
        .top-bar .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-name {
            color: #e0e0e0;
            font-size: 14px;
        }
        
        .logout-btn {
            background: #4a9eff;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .logout-btn:hover {
            background: #3a8eef;
        }
        
        .logout-btn i {
            font-size: 14px;
        }
        
        /* Content Area */
        .content-area {
            padding: 30px;
        }
        
        /* Cards */
        .card {
            background: #2d2d2d;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.5);
            padding: 30px;
            border: 1px solid #404040;
            margin-bottom: 20px;
        }
        
        .card-header {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #404040;
        }
        
        .card-header h3 {
            color: #e0e0e0;
            font-size: 18px;
            font-weight: 600;
        }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%);
            border: 1px solid #404040;
            border-radius: 8px;
            padding: 25px;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            border-color: #4a9eff;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(74, 158, 255, 0.2);
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
            background: #4a9eff;
            color: white;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 600;
            color: #e0e0e0;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #888;
            font-size: 14px;
        }
        
        /* Buttons */
        .btn {
            display: inline-block;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 14px;
            cursor: pointer;
            border: none;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: #4a9eff;
            color: white;
        }
        
        .btn-primary:hover {
            background: #3a8eef;
        }
        
        .btn-secondary {
            background: #404040;
            color: #e0e0e0;
        }
        
        .btn-secondary:hover {
            background: #505050;
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c82333;
        }
        
        /* Tables */
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        thead {
            background: #1a1a1a;
        }
        
        th {
            padding: 15px;
            text-align: left;
            color: #4a9eff;
            font-weight: 600;
            border-bottom: 2px solid #404040;
        }
        
        td {
            padding: 15px;
            border-bottom: 1px solid #404040;
        }
        
        tbody tr:hover {
            background: #1a1a1a;
        }
        
        /* Form Elements */
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #e0e0e0;
            font-weight: 500;
        }
        
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="number"],
        input[type="date"],
        input[type="time"],
        input[type="url"],
        select,
        textarea {
            width: 100%;
            padding: 12px;
            background: #1a1a1a;
            border: 1px solid #404040;
            border-radius: 5px;
            font-size: 16px;
            color: #e0e0e0;
            transition: border-color 0.3s;
            font-family: inherit;
        }
        
        input:focus,
        select:focus,
        textarea:focus {
            outline: none;
            border-color: #4a9eff;
        }
        
        /* Time input specific styling */
        input[type="time"]::-webkit-calendar-picker-indicator {
            filter: invert(1);
            cursor: pointer;
        }
        
        input[type="time"]::-webkit-inner-spin-button,
        input[type="time"]::-webkit-outer-spin-button {
            filter: invert(1);
        }
        
        textarea {
            resize: vertical;
            min-height: 120px;
        }
        
        /* Alert Messages */
        .alert {
            padding: 15px 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #28a745;
            color: white;
        }
        
        .alert-error {
            background: #dc3545;
            color: white;
        }
        
        .alert-warning {
            background: #ffc107;
            color: #000;
        }
        
        .alert-info {
            background: #17a2b8;
            color: white;
        }
        
        /* Mobile Menu Toggle */
        .mobile-menu-toggle {
            display: none;
            background: #4a9eff;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1001;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 999;
        }
        
        /* Responsive Styles */
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: block;
            }
            
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .sidebar-overlay.active {
                display: block;
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .top-bar {
                padding: 12px 15px;
                flex-wrap: wrap;
            }
            
            .top-bar h2 {
                font-size: 16px;
                margin-bottom: 5px;
            }
            
            .top-bar .user-info {
                gap: 10px;
            }
            
            .user-name {
                font-size: 12px;
            }
            
            .content-area {
                padding: 15px;
            }
            
            .card {
                padding: 20px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .stat-card {
                padding: 20px;
            }
            
            .stat-value {
                font-size: 28px;
            }
            
            /* Table Responsive */
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            th, td {
                padding: 10px 8px;
                font-size: 13px;
            }
            
            /* Form adjustments */
            input[type="text"],
            input[type="email"],
            input[type="password"],
            input[type="number"],
            input[type="date"],
            input[type="time"],
            input[type="url"],
            select,
            textarea {
                font-size: 16px; /* Prevents zoom on iOS */
            }
            
            .btn {
                padding: 10px 15px;
                font-size: 13px;
            }
        }
        
        @media (max-width: 480px) {
            .top-bar {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .top-bar h2 {
                width: 100%;
            }
            
            .content-area {
                padding: 10px;
            }
            
            .card {
                padding: 15px;
            }
            
            .stat-value {
                font-size: 24px;
            }
            
            .stat-icon {
                width: 40px;
                height: 40px;
                font-size: 20px;
            }
            
            th, td {
                padding: 8px 5px;
                font-size: 12px;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="instructor-container">
        <!-- Mobile Menu Toggle -->
        <button class="mobile-menu-toggle" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>
        
        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" onclick="toggleSidebar()"></div>
        
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <h1><i class="fas fa-chalkboard-teacher"></i> Instructor</h1>
                <p>{{ auth()->user()->name }}</p>
            </div>
            
            <nav class="sidebar-menu">
                <a href="{{ route('instructor.dashboard') }}" class="menu-item {{ request()->routeIs('instructor.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                
                <div class="menu-section">My Courses</div>
                <a href="{{ route('instructor.courses.index') }}" class="menu-item {{ request()->routeIs('instructor.courses.*') ? 'active' : '' }}">
                    <i class="fas fa-book"></i> My Courses
                </a>
                
                <div class="menu-section">Students</div>
                <a href="{{ route('instructor.students.index') }}" class="menu-item {{ request()->routeIs('instructor.students.*') ? 'active' : '' }}">
                    <i class="fas fa-users"></i> My Students
                </a>
                
                <div class="menu-section">Resources</div>
                <a href="{{ route('instructor.assignments.index') }}" class="menu-item {{ request()->routeIs('instructor.assignments.*') ? 'active' : '' }}">
                    <i class="fas fa-tasks"></i> Assignments
                </a>
                <a href="{{ route('instructor.quizzes.index') }}" class="menu-item {{ request()->routeIs('instructor.quizzes.*') ? 'active' : '' }}">
                    <i class="fas fa-brain"></i> Quizzes
                </a>
                <a href="{{ route('instructor.videos.index') }}" class="menu-item {{ request()->routeIs('instructor.videos.*') ? 'active' : '' }}">
                    <i class="fas fa-video"></i> Class Videos
                </a>
                <a href="{{ route('instructor.resources.index') }}" class="menu-item {{ request()->routeIs('instructor.resources.*') ? 'active' : '' }}">
                    <i class="fas fa-folder-open"></i> Resources
                </a>
                
                <div class="menu-section">Account</div>
                <a href="{{ route('notifications.index') }}" class="menu-item {{ request()->routeIs('notifications.*') ? 'active' : '' }}">
                    <i class="fas fa-bell"></i> Notifications
                </a>
                <a href="{{ route('instructor.profile.index') }}" class="menu-item {{ request()->routeIs('instructor.profile.*') ? 'active' : '' }}">
                    <i class="fas fa-user"></i> My Profile
                </a>
                <button type="button" onclick="openConfirmationModal('Logout', 'Are you sure you want to logout? You will need to login again to access the instructor panel.', '{{ route('logout') }}', 'POST', 'Yes, Logout', '#4a9eff', 'fa-sign-out-alt', '#4a9eff')" class="logout-btn" style="width: 100%; justify-content: flex-start; padding: 12px 20px; border-radius: 0; background: transparent; border: none; color: #e0e0e0; text-align: left; border-left: 3px solid transparent;">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </button>
            </nav>
        </aside>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <h2>@yield('page-title', 'Dashboard')</h2>
                <div class="user-info" style="display: flex; align-items: center; gap: 15px;">
                    @include('partials.notification-bell')
                    <span class="user-name">{{ auth()->user()->name }}</span>
                </div>
            </header>
            
            <!-- Content Area -->
            <main class="content-area">
                @if(session('success'))
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> {{ session('success') }}
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i>
                        <ul style="margin: 5px 0 0 20px;">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                @yield('content')
            </main>
        </div>
    </div>
    
    <!-- Include Confirmation Modal -->
    @include('partials.confirmation-modal')
    
    <script>
        // Mobile sidebar toggle
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.querySelector('.sidebar-overlay');
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }
        
        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(e) {
            const sidebar = document.getElementById('sidebar');
            const toggle = document.querySelector('.mobile-menu-toggle');
            const overlay = document.querySelector('.sidebar-overlay');
            
            if (window.innerWidth <= 768) {
                if (!sidebar.contains(e.target) && !toggle.contains(e.target) && sidebar.classList.contains('active')) {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                }
            }
        });
        
        // Close sidebar on window resize if switching to desktop
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                const sidebar = document.getElementById('sidebar');
                const overlay = document.querySelector('.sidebar-overlay');
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });
    </script>
    
    @stack('scripts')
    
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/692f31c7e58f1d197d894370/1jbg5ktd9';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
    <!--End of Tawk.to Script-->
    
    <!-- Tawk.to Diagnostic Script (Remove after widget works) -->
    <script>
    setTimeout(function() {
        console.log('=== Tawk.to Diagnostic ===');
        if (typeof Tawk_API !== 'undefined') {
            console.log('✅ Tawk_API loaded');
        } else {
            console.log('❌ Tawk_API NOT loaded - Check domain restrictions in Tawk.to dashboard');
        }
        var iframe = document.querySelector('iframe[id*="tawk"]');
        console.log(iframe ? '✅ Widget iframe found' : '❌ Widget iframe NOT found - Check domain/agent status');
    }, 3000);
    </script>
</body>
</html>

