<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Afrilen Technologies') }} - Admin @yield('title', 'Dashboard')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Styles -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Figtree', sans-serif;
            background: #1a1a1a;
            color: #e0e0e0;
            min-height: 100vh;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 260px;
            background: #2d2d2d;
            border-right: 1px solid #404040;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid #404040;
        }
        
        .sidebar-header h1 {
            color: #4a9eff;
            font-size: 20px;
            margin-bottom: 5px;
        }
        
        .sidebar-header p {
            color: #888;
            font-size: 12px;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-item {
            display: block;
            padding: 12px 20px;
            color: #e0e0e0;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover {
            background: #1a1a1a;
            color: #4a9eff;
            border-left-color: #4a9eff;
        }
        
        .menu-item.active {
            background: #1a1a1a;
            color: #4a9eff;
            border-left-color: #4a9eff;
            font-weight: 500;
        }
        
        .menu-section {
            padding: 10px 20px;
            font-size: 11px;
            text-transform: uppercase;
            color: #888;
            font-weight: 600;
            letter-spacing: 1px;
        }
        
        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 260px;
            padding: 0;
        }
        
        /* Top Bar */
        .top-bar {
            background: #2d2d2d;
            border-bottom: 1px solid #404040;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .top-bar h2 {
            color: #e0e0e0;
            font-size: 24px;
            font-weight: 600;
        }
        
        .user-menu {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-avatar {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            background: #4a9eff;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        
        .user-name {
            color: #e0e0e0;
            font-size: 14px;
        }
        
        .logout-btn {
            padding: 8px 16px;
            background: #4a9eff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .logout-btn:hover {
            background: #3a8eef;
        }
        
        .logout-btn i {
            font-size: 14px;
        }
        
        /* Content Area */
        .content-area {
            padding: 30px;
        }
        
        /* Cards */
        .card {
            background: #2d2d2d;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.5);
            padding: 30px;
            border: 1px solid #404040;
            margin-bottom: 20px;
        }
        
        .card-header {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #404040;
        }
        
        .card-header h3 {
            color: #e0e0e0;
            font-size: 18px;
            font-weight: 600;
        }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%);
            border: 1px solid #404040;
            border-radius: 8px;
            padding: 25px;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            border-color: #4a9eff;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(74, 158, 255, 0.2);
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
            background: #4a9eff;
            color: white;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 600;
            color: #e0e0e0;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #888;
            font-size: 14px;
        }
        
        /* Form Inputs */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #e0e0e0;
        }
        
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="number"],
        input[type="date"],
        input[type="url"],
        select {
            width: 100%;
            padding: 12px;
            background: #1a1a1a;
            border: 1px solid #404040;
            border-radius: 5px;
            font-size: 16px;
            color: #e0e0e0;
            transition: border-color 0.3s;
            font-family: inherit;
        }
        
        textarea {
            width: 100%;
            padding: 12px;
            background: #1a1a1a;
            border: 1px solid #404040;
            border-radius: 5px;
            font-size: 16px;
            color: #e0e0e0;
            transition: border-color 0.3s;
            font-family: inherit;
            resize: vertical;
        }
        
        input:focus,
        select:focus,
        textarea:focus {
            outline: none;
            border-color: #4a9eff;
        }
        
        input::placeholder,
        textarea::placeholder {
            color: #888;
        }
        
        /* Buttons */
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary {
            background: #4a9eff;
            color: white;
        }
        
        .btn-primary:hover {
            background: #3a8eef;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(74, 158, 255, 0.3);
        }
        
        .btn-secondary {
            background: #404040;
            color: #e0e0e0;
        }
        
        .btn-secondary:hover {
            background: #505050;
        }
        
        /* Tables */
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .table th {
            text-align: left;
            padding: 12px;
            background: #1a1a1a;
            color: #e0e0e0;
            font-weight: 600;
            border-bottom: 2px solid #404040;
        }
        
        .table td {
            padding: 12px;
            border-bottom: 1px solid #404040;
            color: #e0e0e0;
        }
        
        .table tr:hover {
            background: #1a1a1a;
        }
        
        /* Alerts */
        .alert {
            padding: 12px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #1f3d1f;
            color: #6bff6b;
            border: 1px solid #2a5a2a;
        }
        
        .alert-danger {
            background: #3d1f1f;
            color: #ff6b6b;
            border: 1px solid #5a2a2a;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>Afrilen Technologies</h1>
                <p>Admin Portal</p>
            </div>
            
            <nav class="sidebar-menu">
                <div class="menu-section">Main</div>
                <a href="{{ route('admin.dashboard') }}" class="menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                    Dashboard
                </a>
                
                <div class="menu-section">Management</div>
                <a href="{{ route('admin.students.index') }}" class="menu-item {{ request()->routeIs('admin.students.*') ? 'active' : '' }}">
                    Students
                </a>
                <a href="{{ route('admin.instructors.index') }}" class="menu-item {{ request()->routeIs('admin.instructors.*') ? 'active' : '' }}">
                    Instructors
                </a>
                <a href="{{ route('admin.admins.index') }}" class="menu-item {{ request()->routeIs('admin.admins.*') ? 'active' : '' }}">
                    Admins
                </a>
                
                <div class="menu-section">Courses</div>
                <a href="{{ route('admin.courses.index') }}" class="menu-item {{ request()->routeIs('admin.courses.*') && !request()->routeIs('admin.course-offerings.*') ? 'active' : '' }}">
                    Courses
                </a>
                <a href="{{ route('admin.course-offerings.index') }}" class="menu-item {{ request()->routeIs('admin.course-offerings.*') ? 'active' : '' }}">
                    Course Offerings
                </a>
                <a href="{{ route('admin.enrollments.index') }}" class="menu-item {{ request()->routeIs('admin.enrollments.*') ? 'active' : '' }}">
                    Enrollments
                </a>
                
                <div class="menu-section">Content & Media</div>
                <a href="{{ route('admin.class-videos.index') }}" class="menu-item {{ request()->routeIs('admin.class-videos.*') ? 'active' : '' }}">
                    Class Videos
                </a>
                <a href="{{ route('admin.quizzes.index') }}" class="menu-item {{ request()->routeIs('admin.quizzes.*') ? 'active' : '' }}">
                    <i class="fas fa-brain"></i> Quizzes
                </a>
                <a href="{{ route('admin.resources.index') }}" class="menu-item {{ request()->routeIs('admin.resources.*') ? 'active' : '' }}">
                    <i class="fas fa-folder-open"></i> Resources
                </a>
                
                <div class="menu-section">Certificates</div>
                <a href="{{ route('admin.certificates.index') }}" class="menu-item {{ request()->routeIs('admin.certificates.*') ? 'active' : '' }}">
                    Certificates
                </a>
                
                <div class="menu-section">Finance</div>
                <a href="{{ route('admin.student-finances.index') }}" class="menu-item {{ request()->routeIs('admin.student-finances.*') ? 'active' : '' }}">
                    Student Finances
                </a>
                <a href="{{ route('admin.fee-payments.index') }}" class="menu-item {{ request()->routeIs('admin.fee-payments.*') ? 'active' : '' }}">
                    Payment History
                </a>
                
                <div class="menu-section">Communication</div>
                <a href="{{ route('admin.announcements.index') }}" class="menu-item {{ request()->routeIs('admin.announcements.*') ? 'active' : '' }}">
                    <i class="fas fa-bullhorn"></i> Announcements
                </a>
                
                <div class="menu-section">System</div>
                <a href="{{ route('admin.settings.index') }}" class="menu-item {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}">
                    <i class="fas fa-cog"></i> Settings
                </a>
                
                <div class="menu-section">Account</div>
                <a href="{{ route('notifications.index') }}" class="menu-item {{ request()->routeIs('notifications.*') ? 'active' : '' }}">
                    <i class="fas fa-bell"></i> Notifications
                </a>
                <a href="{{ route('admin.profile.index') }}" class="menu-item {{ request()->routeIs('admin.profile.*') ? 'active' : '' }}">
                    <i class="fas fa-user"></i> My Profile
                </a>
            </nav>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <div class="top-bar">
                <h2>@yield('page-title', 'Dashboard')</h2>
                <div class="user-menu">
                    @include('partials.notification-bell')
                    <div class="user-info">
                        <div class="user-avatar">
                            {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                        </div>
                        <span class="user-name">{{ auth()->user()->name }}</span>
                    </div>
                    <button type="button" onclick="openConfirmationModal('Logout', 'Are you sure you want to logout? You will need to login again to access the admin panel.', '{{ route('logout') }}', 'POST', 'Yes, Logout', '#4a9eff', 'fa-sign-out-alt', '#4a9eff')" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </button>
                </div>
            </div>
            
            <!-- Content Area -->
            <div class="content-area">
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                
                @if (session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif
                
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul style="list-style: none; margin: 0; padding: 0;">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                @yield('content')
            </div>
        </main>
    </div>
    
    @include('partials.confirmation-modal')
    @stack('scripts')
    
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/692f31c7e58f1d197d894370/1jbg5ktd9';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
    <!--End of Tawk.to Script-->
    
    <!-- Tawk.to Diagnostic Script (Remove after widget works) -->
    <script>
    setTimeout(function() {
        console.log('=== Tawk.to Diagnostic ===');
        if (typeof Tawk_API !== 'undefined') {
            console.log('✅ Tawk_API loaded');
        } else {
            console.log('❌ Tawk_API NOT loaded - Check domain restrictions in Tawk.to dashboard');
        }
        var iframe = document.querySelector('iframe[id*="tawk"]');
        console.log(iframe ? '✅ Widget iframe found' : '❌ Widget iframe NOT found - Check domain/agent status');
    }, 3000);
    </script>
</body>
</html>

