@extends('layouts.instructor')

@section('title', 'Class Videos')
@section('page-title', 'Class Videos')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3><i class="fas fa-video"></i> My Class Videos</h3>
            <a href="{{ route('instructor.videos.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Video
            </a>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('instructor.videos.index') }}" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>{{ $course->name }}</option>
                    @endforeach
                </select>
                <select name="published" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="1" {{ request('published') == '1' ? 'selected' : '' }}>Published</option>
                    <option value="0" {{ request('published') == '0' ? 'selected' : '' }}>Draft</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request()->anyFilled(['course_id', 'published']))
                    <a href="{{ route('instructor.videos.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($videos->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Course</th>
                            <th>Session Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($videos as $video)
                            <tr>
                                <td><strong>{{ $video->title }}</strong></td>
                                <td>{{ $video->course->name }}</td>
                                <td>{{ $video->session_date ? \Carbon\Carbon::parse($video->session_date)->format('M d, Y') : 'N/A' }}</td>
                                <td>
                                    @if($video->is_published)
                                        <span style="color: #6bff6b;">Published</span>
                                    @else
                                        <span style="color: #888;">Draft</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('instructor.videos.show', $video->id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="{{ route('instructor.videos.edit', $video->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <button type="button" onclick="openConfirmationModal('Delete Video', 'Are you sure you want to delete {{ addslashes($video->title) }}? This action cannot be undone.', '{{ route('instructor.videos.destroy', $video->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div style="margin-top: 20px;">{{ $videos->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-video" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No class videos found.</p>
                    <a href="{{ route('instructor.videos.create') }}" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-plus"></i> Add First Video
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

