@extends('layouts.instructor')

@section('title', 'Create Class Video')
@section('page-title', 'Create New Class Video')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.videos.index') }}" class="btn btn-secondary">← Back to Videos</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-video"></i> Create New Class Video</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div style="margin-bottom: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> {{ session('success') }}
                </div>
            @endif
            
            @if($errors->any())
                <div style="margin-bottom: 20px; padding: 15px; background: #4d1a1a; border: 1px solid #ff6b6b; border-radius: 5px; color: #ff6b6b;">
                    <strong>Error:</strong>
                    <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <form method="POST" action="{{ route('instructor.videos.store') }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required onchange="loadCourseOfferings(this.value)">
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering (Optional)</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">Select Course Offering (Optional)</option>
                            @foreach($courses as $course)
                                @if($course->courseOfferings && $course->courseOfferings->count() > 0)
                                    @foreach($course->courseOfferings as $offering)
                                        <option value="{{ $offering->id }}" 
                                            data-course="{{ $course->id }}"
                                            {{ old('course_offering_id') == $offering->id ? 'selected' : '' }}
                                            style="display: none;">
                                            {{ $offering->name ?? 'Offering ' . $offering->id }}
                                        </option>
                                    @endforeach
                                @endif
                            @endforeach
                        </select>
                        @error('course_offering_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="title">Video Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title') }}" 
                        required
                        autofocus
                        placeholder="e.g., Introduction to Flutter Widgets"
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Brief description of the video content..."
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="session_date">Session Date *</label>
                        <input 
                            type="date" 
                            id="session_date" 
                            name="session_date" 
                            value="{{ old('session_date', date('Y-m-d')) }}" 
                            required
                        >
                        @error('session_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="video_duration">Video Duration (HH:MM)</label>
                        <input 
                            type="time" 
                            id="video_duration" 
                            name="video_duration" 
                            value="{{ old('video_duration') }}"
                            step="1"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Format: HH:MM (e.g., 01:30 for 1 hour 30 minutes)</small>
                        @error('video_duration')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="mega_storage_link">Mega Storage Link</label>
                    <input 
                        type="url" 
                        id="mega_storage_link" 
                        name="mega_storage_link" 
                        value="{{ old('mega_storage_link') }}" 
                        placeholder="https://mega.nz/..."
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Full URL to the video on Mega storage</small>
                    @error('mega_storage_link')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="download_key">Download Key</label>
                    <input 
                        type="text" 
                        id="download_key" 
                        name="download_key" 
                        value="{{ old('download_key') }}" 
                        placeholder="Enter download key if required"
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Key required to download the video (if applicable)</small>
                    @error('download_key')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="thumbnail_url">Thumbnail URL</label>
                    <input 
                        type="url" 
                        id="thumbnail_url" 
                        name="thumbnail_url" 
                        value="{{ old('thumbnail_url') }}" 
                        placeholder="https://example.com/thumbnail.jpg"
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">URL to video thumbnail image</small>
                    @error('thumbnail_url')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="is_published" 
                                value="1"
                                {{ old('is_published') ? 'checked' : '' }}
                                style="width: auto;"
                            >
                            <span>Publish Video (make visible to students)</span>
                        </label>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Video
                    </button>
                    <a href="{{ route('instructor.videos.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
    
    @push('scripts')
    <script>
        function loadCourseOfferings(courseId) {
            const offeringSelect = document.getElementById('course_offering_id');
            const options = offeringSelect.querySelectorAll('option');
            
            // Reset offering selection
            offeringSelect.value = '';
            
            options.forEach(option => {
                if (option.value === '') {
                    option.style.display = 'block';
                } else {
                    const optionCourseId = option.getAttribute('data-course');
                    if (optionCourseId == courseId) {
                        option.style.display = 'block';
                    } else {
                        option.style.display = 'none';
                    }
                }
            });
        }
        
        // Load offerings if course is pre-selected
        const courseSelect = document.getElementById('course_id');
        if (courseSelect.value) {
            loadCourseOfferings(courseSelect.value);
        }
    </script>
    @endpush
@endsection
