@extends('layouts.instructor')

@section('title', 'Student Details')
@section('page-title', 'Student Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.students.index') }}" class="btn btn-secondary">← Back to My Students</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $student->name }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <!-- Profile Picture Section -->
            <div style="text-align: center; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid #404040;">
                @if($student->profile_picture)
                    @php
                        try {
                            $decrypted = \Illuminate\Support\Facades\Crypt::decryptString($student->profile_picture);
                        } catch (\Exception $e) {
                            $decrypted = null;
                        }
                    @endphp
                    @if($decrypted)
                        <img src="{{ $decrypted }}" alt="Profile Picture" 
                             style="width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 3px solid #4a9eff; box-shadow: 0 4px 12px rgba(74, 158, 255, 0.3);">
                    @else
                        <div style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);">
                            <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                        </div>
                    @endif
                @else
                    <div style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);">
                        <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                    </div>
                @endif
            </div>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Student Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Full Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $student->name }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Email</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $student->email }}</span>
                    </div>
                    @if($student->school_id)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">School ID</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $student->school_id }}</span>
                    </div>
                    @endif
                    @if($student->phone)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Phone</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $student->phone }}</span>
                    </div>
                    @endif
                </div>
            </div>
            
            <!-- Enrolled Courses Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Enrolled Courses</h4>
                @if($enrollments->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Course</th>
                                <th>Code</th>
                                <th>Enrollment Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($enrollments as $enrollment)
                                <tr>
                                    <td>
                                        <a href="{{ route('instructor.courses.show', $enrollment->course_id) }}" style="color: #4a9eff; text-decoration: none;">
                                            {{ $enrollment->course->name }}
                                        </a>
                                    </td>
                                    <td>{{ $enrollment->course->code }}</td>
                                    <td>{{ $enrollment->enrollment_date ? $enrollment->enrollment_date->format('M d, Y') : 'N/A' }}</td>
                                    <td>
                                        @if($enrollment->status == 'active')
                                            <span style="color: #6bff6b;">Active</span>
                                        @else
                                            <span style="color: #888;">{{ ucfirst($enrollment->status) }}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">This student is not enrolled in any of your courses.</p>
                @endif
            </div>
        </div>
    </div>
@endsection

