@extends('layouts.instructor')

@section('title', 'My Students')
@section('page-title', 'My Students')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-users"></i> My Students</h3>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('instructor.students.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, or school ID..." 
                    value="{{ request('search') }}"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request('search'))
                    <a href="{{ route('instructor.students.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($students->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>School ID</th>
                            <th>Courses Enrolled</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($students as $student)
                            <tr>
                                <td><strong>{{ $student->name }}</strong></td>
                                <td>{{ $student->email }}</td>
                                <td>{{ $student->school_id ?? 'N/A' }}</td>
                                <td>{{ $student->enrollments_count }}</td>
                                <td>
                                    <a href="{{ route('instructor.students.show', $student->id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View Details
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $students->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-users" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No students found.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

