@extends('layouts.instructor')

@section('title', 'Resource Details')
@section('page-title', 'Resource Details')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>{{ $resource->title }}</h3>
            <a href="{{ route('instructor.resources.index') }}" class="btn btn-secondary">Back</a>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
                @if($resource->resource_type)
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Resource Type</strong>
                        <p style="font-size: 16px;">{{ $resource->resource_type }}</p>
                    </div>
                @endif
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Uploaded On</strong>
                    <p style="font-size: 16px;">{{ $resource->created_at->format('M d, Y') }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Downloads</strong>
                    <p style="font-size: 16px;">{{ $resource->download_count }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">File Size</strong>
                    <p style="font-size: 16px;">{{ $resource->formatted_file_size }}</p>
                </div>
            </div>
            
            @if($resource->description)
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 10px;">Description</strong>
                    <p style="line-height: 1.6; white-space: pre-wrap;">{{ $resource->description }}</p>
                </div>
            @endif
            
            <div style="border-top: 1px solid #404040; padding-top: 20px;">
                <h4 style="margin-bottom: 15px;">Resource File</h4>
                <div style="background: #1a1a1a; padding: 15px; border-radius: 5px; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
                    <div>
                        <strong>{{ $resource->file_name }}</strong>
                        <small style="display: block; color: #888; margin-top: 5px;">
                            {{ $resource->formatted_file_size }} | {{ strtoupper($resource->file_extension ?? 'N/A') }}
                        </small>
                    </div>
                    <a href="{{ route('instructor.resources.download', $resource->id) }}" class="btn btn-primary">
                        <i class="fas fa-download"></i> Download Resource
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection

