@extends('layouts.instructor')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-book"></i></div>
            <div class="stat-value">{{ $stats['total_courses'] ?? 0 }}</div>
            <div class="stat-label">My Courses</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-users"></i></div>
            <div class="stat-value">{{ $stats['total_students'] ?? 0 }}</div>
            <div class="stat-label">Total Students</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-graduation-cap"></i></div>
            <div class="stat-value">{{ $stats['total_enrollments'] ?? 0 }}</div>
            <div class="stat-label">Total Enrollments</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-video"></i></div>
            <div class="stat-value">{{ $stats['total_videos'] ?? 0 }}</div>
            <div class="stat-label">Class Videos</div>
        </div>
    </div>
    
    <!-- Welcome Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tachometer-alt"></i> Welcome to Instructor Dashboard</h3>
        </div>
        <div>
            <p style="color: #e0e0e0; margin-bottom: 20px;">
                Welcome back, <strong>{{ auth()->user()->name }}</strong>! This is your instructor dashboard where you can manage your courses, students, and class materials.
            </p>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-bolt"></i> Quick Actions</h4>
                    <ul style="list-style: none; padding: 0;">
                        <li style="margin-bottom: 10px;">
                            <a href="{{ route('instructor.courses.index') }}" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-book"></i> View My Courses</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="{{ route('instructor.students.index') }}" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-users"></i> View My Students</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="{{ route('instructor.assignments.index') }}" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-tasks"></i> Manage Assignments</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="{{ route('instructor.videos.index') }}" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-video"></i> Manage Videos</a>
                        </li>
                    </ul>
                </div>
                
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-info-circle"></i> Account Information</h4>
                    <ul style="list-style: none; padding: 0; color: #888;">
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-envelope"></i> {{ auth()->user()->email }}</li>
                        @if(auth()->user()->phone)
                            <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-phone"></i> {{ auth()->user()->phone }}</li>
                        @endif
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-calendar"></i> Today: {{ now()->format('M d, Y') }}</li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-clock"></i> Server Time: {{ now()->format('h:i A') }}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activities Section -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 20px;">
        <!-- My Courses -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-book"></i> My Courses</h3>
                <a href="{{ route('instructor.courses.index') }}" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                @if(isset($recentCourses) && $recentCourses->count() > 0)
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        @foreach($recentCourses as $course)
                            <a href="{{ route('instructor.courses.show', $course->id) }}" style="text-decoration: none; display: block;">
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222'; this.style.borderLeftColor='#6bff6b';" onmouseout="this.style.background='#1a1a1a'; this.style.borderLeftColor='#4a9eff';">
                                    <div>
                                        <strong style="color: #e0e0e0; display: block;">{{ $course->name }}</strong>
                                        <span style="color: #888; font-size: 13px;">{{ $course->code }}</span>
                                        <div style="margin-top: 5px;">
                                            <span style="color: #888; font-size: 12px;">
                                                {{ $course->enrollments->count() }} enrolled students
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No courses assigned yet</p>
                @endif
            </div>
        </div>
        
        <!-- Recent Enrollments -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-graduation-cap"></i> Recent Enrollments</h3>
                <a href="{{ route('instructor.students.index') }}" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                @if(isset($recentEnrollments) && $recentEnrollments->count() > 0)
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        @foreach($recentEnrollments as $enrollment)
                            @if($enrollment->student && $enrollment->course)
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff;">
                                    <div style="display: flex; justify-content: space-between; align-items: start;">
                                        <div style="flex: 1;">
                                            <strong style="color: #e0e0e0; display: block;">{{ $enrollment->student->name }}</strong>
                                            <span style="color: #888; font-size: 13px;">{{ $enrollment->course->name }}</span>
                                        </div>
                                        <span style="color: #888; font-size: 12px; white-space: nowrap; margin-left: 10px;">
                                            {{ $enrollment->created_at ? $enrollment->created_at->format('M d, Y') : 'N/A' }}
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No recent enrollments</p>
                @endif
            </div>
        </div>
        
        <!-- Recent Videos -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-video"></i> Recent Videos</h3>
                <a href="{{ route('instructor.videos.index') }}" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                @if(isset($recentVideos) && $recentVideos->count() > 0)
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        @foreach($recentVideos as $video)
                            @if($video->course)
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                                    <div>
                                        <strong style="color: #e0e0e0; display: block;">{{ $video->title }}</strong>
                                        <span style="color: #888; font-size: 13px;">{{ $video->course->name }}</span>
                                        <div style="margin-top: 5px;">
                                            <span style="color: #888; font-size: 12px;">
                                                {{ $video->session_date ? \Carbon\Carbon::parse($video->session_date)->format('M d, Y') : 'N/A' }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No videos uploaded yet</p>
                @endif
            </div>
        </div>
    </div>
@endsection

