@extends('layouts.instructor')

@section('title', 'Course Details')
@section('page-title', 'Course Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.courses.index') }}" class="btn btn-secondary">← Back to My Courses</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $course->name }} ({{ $course->code }})</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Code</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;">{{ $course->code }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->name }}</span>
                    </div>
                    @if($course->description)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Description</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->description }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Credits</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->credits }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Fees</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">₵{{ number_format($course->fees, 2) }}</span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Statistics</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Enrolled Students</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">{{ $enrolledStudents }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Chapters</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">{{ $totalChapters }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Published Chapters</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">{{ $publishedChapters }}</span>
                    </div>
                </div>
            </div>
            
            <!-- Course Chapters Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Chapters</h4>
                @if($course->chapters->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Chapter #</th>
                                <th>Title</th>
                                <th>Session</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($course->chapters->sortBy('order') as $chapter)
                                <tr>
                                    <td>{{ $chapter->chapter_number }}</td>
                                    <td><strong>{{ $chapter->title }}</strong></td>
                                    <td>Session {{ $chapter->session_number }}</td>
                                    <td>
                                        @if($chapter->is_published)
                                            <span style="color: #6bff6b;">Published</span>
                                        @else
                                            <span style="color: #888;">Draft</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No chapters added yet. Contact admin to add chapters.</p>
                @endif
            </div>
            
            <!-- Enrolled Students Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Enrolled Students</h4>
                <a href="{{ route('instructor.students.index') }}?course={{ $course->id }}" class="btn btn-primary" style="margin-bottom: 15px;">
                    <i class="fas fa-users"></i> View All Students
                </a>
                @if($course->enrollments->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Student Name</th>
                                <th>Email</th>
                                <th>School ID</th>
                                <th>Enrollment Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($course->enrollments->take(10) as $enrollment)
                                <tr>
                                    <td><a href="{{ route('instructor.students.show', $enrollment->student_id) }}" style="color: #4a9eff; text-decoration: none;">{{ $enrollment->student->name }}</a></td>
                                    <td>{{ $enrollment->student->email }}</td>
                                    <td>{{ $enrollment->student->school_id ?? 'N/A' }}</td>
                                    <td>{{ $enrollment->enrollment_date ? $enrollment->enrollment_date->format('M d, Y') : 'N/A' }}</td>
                                    <td>
                                        @if($enrollment->status == 'active')
                                            <span style="color: #6bff6b;">Active</span>
                                        @else
                                            <span style="color: #888;">{{ ucfirst($enrollment->status) }}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @if($course->enrollments->count() > 10)
                        <p style="color: #888; text-align: center; margin-top: 15px;">
                            Showing first 10 of {{ $course->enrollments->count() }} enrolled students. 
                            <a href="{{ route('instructor.students.index') }}?course={{ $course->id }}" style="color: #4a9eff;">View all students</a>
                        </p>
                    @endif
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No students enrolled yet.</p>
                @endif
            </div>
        </div>
    </div>
@endsection

