@extends('layouts.instructor')

@section('title', 'My Courses')
@section('page-title', 'My Courses')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-book"></i> My Courses</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($courses->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Course Name</th>
                            <th>Credits</th>
                            <th>Fees</th>
                            <th>Students Enrolled</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($courses as $course)
                            <tr>
                                <td><strong>{{ $course->code }}</strong></td>
                                <td>{{ $course->name }}</td>
                                <td>{{ $course->credits }}</td>
                                <td>₵{{ number_format($course->fees, 2) }}</td>
                                <td>{{ $course->enrollments_count }}</td>
                                <td>
                                    <a href="{{ route('instructor.courses.show', $course->id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View Details
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-book" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No courses assigned to you yet.</p>
                    <p style="font-size: 14px; margin-top: 10px;">Please contact the administrator to get courses assigned.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

