@extends('layouts.instructor')

@section('title', 'Assignment Submissions')
@section('page-title', 'Assignment Submissions')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.assignments.show', $assignment->id) }}" class="btn btn-secondary">← Back to Assignment</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-file-alt"></i> Submissions: {{ $assignment->title }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div style="margin-bottom: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> {{ session('success') }}
                </div>
            @endif
            
            @if($errors->any())
                <div style="margin-bottom: 20px; padding: 15px; background: #4d1a1a; border: 1px solid #ff6b6b; border-radius: 5px; color: #ff6b6b;">
                    <strong>Error:</strong>
                    <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <div style="margin-bottom: 30px; padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Submissions</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">{{ $submissions->count() }}</span>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Graded</strong>
                        <span style="color: #6bff6b; font-size: 24px; font-weight: 600;">{{ $submissions->where('status', 'graded')->count() }}</span>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Pending</strong>
                        <span style="color: #ffc107; font-size: 24px; font-weight: 600;">{{ $submissions->where('status', 'submitted')->count() }}</span>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Due Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">
                            {{ $assignment->due_date->format('M d, Y') }}
                            @if($assignment->due_time)
                                @php
                                    $dueTimeStr = is_string($assignment->due_time) ? $assignment->due_time : (is_object($assignment->due_time) ? $assignment->due_time->format('H:i') : $assignment->due_time);
                                @endphp
                                at {{ date('h:i A', strtotime($dueTimeStr)) }}
                            @endif
                        </span>
                    </div>
                </div>
            </div>
            
            @if($submissions->count() > 0)
                @foreach($submissions as $submission)
                    <div class="card" style="margin-bottom: 20px;">
                        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <h4 style="color: #e0e0e0; margin: 0;">{{ $submission->student->name }}</h4>
                                <p style="color: #888; font-size: 14px; margin: 5px 0 0 0;">{{ $submission->student->email }}</p>
                            </div>
                            <div style="text-align: right;">
                                @if($submission->status == 'graded')
                                    <span style="color: #6bff6b; font-weight: 600;">Graded</span>
                                    <div style="margin-top: 5px;">
                                        <span style="color: #e0e0e0; font-size: 18px; font-weight: 600;">
                                            {{ number_format($submission->score, 1) }} / {{ number_format($assignment->total_points, 1) }}
                                        </span>
                                        <span style="color: #888; font-size: 14px;">
                                            ({{ number_format($submission->grade_percentage, 1) }}%)
                                        </span>
                                    </div>
                                @elseif($submission->status == 'submitted')
                                    <span style="color: #ffc107; font-weight: 600;">Pending Review</span>
                                @else
                                    <span style="color: #888;">Draft</span>
                                @endif
                            </div>
                        </div>
                        
                        <div style="padding: 20px;">
                            <div style="margin-bottom: 15px;">
                                <strong style="color: #888; display: block; margin-bottom: 5px;">Submitted</strong>
                                <span style="color: #e0e0e0;">
                                    @if($submission->submitted_at)
                                        {{ $submission->submitted_at->format('M d, Y h:i A') }}
                                        @if($submission->is_late)
                                            <span style="color: #ff6b6b;">(Late)</span>
                                        @endif
                                    @else
                                        Not submitted yet
                                    @endif
                                </span>
                            </div>
                            
                            @if($submission->submission_text)
                            <div style="margin-bottom: 15px;">
                                <strong style="color: #888; display: block; margin-bottom: 5px;">Submission</strong>
                                <div style="color: #e0e0e0; padding: 15px; background: #1a1a1a; border-radius: 5px; white-space: pre-wrap;">{{ $submission->submission_text }}</div>
                            </div>
                            @endif
                            
                            @if($submission->submission_file)
                            <div style="margin-bottom: 15px;">
                                <strong style="color: #888; display: block; margin-bottom: 5px;">Attached File</strong>
                                <a href="{{ asset('storage/' . $submission->submission_file) }}" target="_blank" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                    <i class="fas fa-download"></i> Download File
                                </a>
                            </div>
                            @endif
                            
                            @if($submission->status == 'graded' && $submission->instructor_feedback)
                            <div style="margin-bottom: 15px;">
                                <strong style="color: #888; display: block; margin-bottom: 5px;">Feedback</strong>
                                <div style="color: #e0e0e0; padding: 15px; background: #1a1a1a; border-radius: 5px; white-space: pre-wrap;">{{ $submission->instructor_feedback }}</div>
                            </div>
                            @endif
                            
                            @if($submission->status == 'submitted' || $submission->status == 'draft')
                            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #404040;">
                                <h5 style="color: #4a9eff; margin-bottom: 15px;">Grade Submission</h5>
                                <form method="POST" action="{{ route('instructor.assignments.grade', $submission->id) }}">
                                    @csrf
                                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 15px;">
                                        <div class="form-group">
                                            <label for="score_{{ $submission->id }}">Score (out of {{ number_format($assignment->total_points, 0) }})</label>
                                            <input 
                                                type="number" 
                                                id="score_{{ $submission->id }}" 
                                                name="score" 
                                                required
                                                min="0"
                                                max="{{ $assignment->total_points }}"
                                                step="0.01"
                                                value="{{ old('score', $submission->score) }}"
                                            >
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="feedback_{{ $submission->id }}">Feedback</label>
                                        <textarea 
                                            id="feedback_{{ $submission->id }}" 
                                            name="instructor_feedback" 
                                            rows="4"
                                            placeholder="Provide feedback to the student..."
                                        >{{ old('instructor_feedback', $submission->instructor_feedback) }}</textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-check"></i> Submit Grade
                                    </button>
                                </form>
                            </div>
                            @else
                            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #404040;">
                                <p style="color: #888; font-size: 14px;">
                                    @if($submission->graded_at)
                                        Graded on {{ $submission->graded_at->format('M d, Y h:i A') }}
                                        @if($submission->gradedBy)
                                            by {{ $submission->gradedBy->name }}
                                        @endif
                                    @else
                                        Graded
                                        @if($submission->gradedBy)
                                            by {{ $submission->gradedBy->name }}
                                        @endif
                                    @endif
                                </p>
                            </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-file-alt" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No submissions yet for this assignment.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

