@extends('layouts.instructor')

@section('title', 'Edit Assignment')
@section('page-title', 'Edit Assignment')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.assignments.show', $assignment->id) }}" class="btn btn-secondary">← Back to Assignment</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-edit"></i> Edit Assignment: {{ $assignment->title }}</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('instructor.assignments.update', $assignment->id) }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required onchange="loadChapters(this.value)">
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ (old('course_id', $assignment->course_id) == $course->id) ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="chapter_id">Chapter (Optional)</label>
                        <select id="chapter_id" name="chapter_id">
                            <option value="">Select Chapter (Optional)</option>
                            @foreach($courses as $course)
                                @foreach($course->chapters as $chapter)
                                    <option value="{{ $chapter->id }}" 
                                        data-course="{{ $course->id }}"
                                        {{ (old('chapter_id', $assignment->chapter_id) == $chapter->id) ? 'selected' : '' }}
                                        style="display: none;">
                                        {{ $chapter->title }} (Chapter {{ $chapter->chapter_number }})
                                    </option>
                                @endforeach
                            @endforeach
                        </select>
                        @error('chapter_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="title">Assignment Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title', $assignment->title) }}" 
                        required
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="3"
                    >{{ old('description', $assignment->description) }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="instructions">Instructions</label>
                    <textarea 
                        id="instructions" 
                        name="instructions" 
                        rows="6"
                    >{{ old('instructions', $assignment->instructions) }}</textarea>
                    @error('instructions')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="due_date">Due Date *</label>
                        <input 
                            type="date" 
                            id="due_date" 
                            name="due_date" 
                            value="{{ old('due_date', $assignment->due_date->format('Y-m-d')) }}" 
                            required
                        >
                        @error('due_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="due_time">Due Time (Optional)</label>
                        <input 
                            type="time" 
                            id="due_time" 
                            name="due_time" 
                            value="{{ old('due_time', $assignment->due_time ? (is_string($assignment->due_time) ? substr($assignment->due_time, 0, 5) : (is_object($assignment->due_time) ? $assignment->due_time->format('H:i') : substr($assignment->due_time, 0, 5))) : '') }}"
                        >
                        @error('due_time')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="total_points">Total Points *</label>
                        <input 
                            type="number" 
                            id="total_points" 
                            name="total_points" 
                            value="{{ old('total_points', $assignment->total_points) }}" 
                            required
                            min="1"
                            max="1000"
                            step="0.01"
                        >
                        @error('total_points')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="allow_late_submission" 
                                value="1"
                                {{ old('allow_late_submission', $assignment->allow_late_submission) ? 'checked' : '' }}
                                style="width: auto;"
                            >
                            <span>Allow Late Submission</span>
                        </label>
                    </div>
                    
                    <div class="form-group" id="late_penalty_group" style="display: {{ $assignment->allow_late_submission ? 'block' : 'none' }};">
                        <label for="late_penalty_percentage">Late Penalty (% per day)</label>
                        <input 
                            type="number" 
                            id="late_penalty_percentage" 
                            name="late_penalty_percentage" 
                            value="{{ old('late_penalty_percentage', $assignment->late_penalty_percentage) }}" 
                            min="0"
                            max="100"
                        >
                        @error('late_penalty_percentage')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="is_published" 
                                value="1"
                                {{ old('is_published', $assignment->is_published) ? 'checked' : '' }}
                                style="width: auto;"
                            >
                            <span>Publish Assignment (make visible to students)</span>
                        </label>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Assignment
                    </button>
                    <a href="{{ route('instructor.assignments.show', $assignment->id) }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
    
    @push('scripts')
    <script>
        function loadChapters(courseId) {
            const chapterSelect = document.getElementById('chapter_id');
            const options = chapterSelect.querySelectorAll('option');
            
            options.forEach(option => {
                if (option.value === '') {
                    option.style.display = 'block';
                } else {
                    const optionCourseId = option.getAttribute('data-course');
                    if (optionCourseId == courseId) {
                        option.style.display = 'block';
                    } else {
                        option.style.display = 'none';
                        if (option.selected && optionCourseId != courseId) {
                            option.selected = false;
                        }
                    }
                }
            });
        }
        
        document.querySelector('input[name="allow_late_submission"]').addEventListener('change', function() {
            document.getElementById('late_penalty_group').style.display = this.checked ? 'block' : 'none';
        });
        
        // Load chapters on page load
        if (document.getElementById('course_id').value) {
            loadChapters(document.getElementById('course_id').value);
        }
    </script>
    @endpush
@endsection

