@extends('layouts.instructor')

@section('title', 'Create Assignment')
@section('page-title', 'Create New Assignment')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('instructor.assignments.index') }}" class="btn btn-secondary">← Back to Assignments</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tasks"></i> Create New Assignment</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('instructor.assignments.store') }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required onchange="loadChapters(this.value)">
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="chapter_id">Chapter (Optional)</label>
                        <select id="chapter_id" name="chapter_id">
                            <option value="">Select Chapter (Optional)</option>
                            @foreach($courses as $course)
                                @foreach($course->chapters as $chapter)
                                    <option value="{{ $chapter->id }}" 
                                        data-course="{{ $course->id }}"
                                        {{ old('chapter_id') == $chapter->id ? 'selected' : '' }}
                                        style="display: none;">
                                        {{ $chapter->title }} (Chapter {{ $chapter->chapter_number }})
                                    </option>
                                @endforeach
                            @endforeach
                        </select>
                        @error('chapter_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="title">Assignment Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title') }}" 
                        required
                        autofocus
                        placeholder="e.g., Flutter Widget Basics Assignment"
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="3"
                        placeholder="Brief description of the assignment..."
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="instructions">Instructions</label>
                    <textarea 
                        id="instructions" 
                        name="instructions" 
                        rows="6"
                        placeholder="Detailed instructions for students..."
                    >{{ old('instructions') }}</textarea>
                    @error('instructions')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="due_date">Due Date *</label>
                        <input 
                            type="date" 
                            id="due_date" 
                            name="due_date" 
                            value="{{ old('due_date', date('Y-m-d')) }}" 
                            required
                            min="{{ date('Y-m-d') }}"
                        >
                        @error('due_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="due_time">Due Time (Optional)</label>
                        <input 
                            type="time" 
                            id="due_time" 
                            name="due_time" 
                            value="{{ old('due_time') }}"
                        >
                        @error('due_time')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="total_points">Total Points *</label>
                        <input 
                            type="number" 
                            id="total_points" 
                            name="total_points" 
                            value="{{ old('total_points', 100) }}" 
                            required
                            min="1"
                            max="1000"
                            step="0.01"
                        >
                        @error('total_points')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="allow_late_submission" 
                                value="1"
                                {{ old('allow_late_submission', true) ? 'checked' : '' }}
                                style="width: auto;"
                            >
                            <span>Allow Late Submission</span>
                        </label>
                    </div>
                    
                    <div class="form-group" id="late_penalty_group" style="display: none;">
                        <label for="late_penalty_percentage">Late Penalty (% per day)</label>
                        <input 
                            type="number" 
                            id="late_penalty_percentage" 
                            name="late_penalty_percentage" 
                            value="{{ old('late_penalty_percentage', 10) }}" 
                            min="0"
                            max="100"
                        >
                        @error('late_penalty_percentage')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="is_published" 
                                value="1"
                                {{ old('is_published') ? 'checked' : '' }}
                                style="width: auto;"
                            >
                            <span>Publish Assignment (make visible to students)</span>
                        </label>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Assignment
                    </button>
                    <a href="{{ route('instructor.assignments.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
    
    @push('scripts')
    <script>
        function loadChapters(courseId) {
            const chapterSelect = document.getElementById('chapter_id');
            const options = chapterSelect.querySelectorAll('option');
            
            // Reset chapter selection
            chapterSelect.value = '';
            
            options.forEach(option => {
                if (option.value === '') {
                    option.style.display = 'block';
                } else {
                    const optionCourseId = option.getAttribute('data-course');
                    if (optionCourseId == courseId) {
                        option.style.display = 'block';
                    } else {
                        option.style.display = 'none';
                    }
                }
            });
        }
        
        // Show/hide late penalty based on checkbox
        document.querySelector('input[name="allow_late_submission"]').addEventListener('change', function() {
            const penaltyGroup = document.getElementById('late_penalty_group');
            if (this.checked) {
                penaltyGroup.style.display = 'block';
            } else {
                penaltyGroup.style.display = 'none';
            }
        });
        
        // Trigger on page load if checkbox is checked
        if (document.querySelector('input[name="allow_late_submission"]').checked) {
            document.getElementById('late_penalty_group').style.display = 'block';
        }
        
        // Load chapters if course is pre-selected
        const courseSelect = document.getElementById('course_id');
        if (courseSelect.value) {
            loadChapters(courseSelect.value);
        }
    </script>
    @endpush
@endsection

