<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Notification - {{ $systemName }}</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #4a9eff;
        }
        .header h1 {
            color: #4a9eff;
            margin: 0;
            font-size: 28px;
        }
        .content {
            margin-bottom: 30px;
        }
        .payment-details {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
            border-left: 4px solid #4a9eff;
        }
        .payment-details h3 {
            margin-top: 0;
            color: #333;
        }
        .payment-details p {
            margin: 10px 0;
            font-size: 14px;
        }
        .payment-details strong {
            color: #4a9eff;
        }
        .student-info {
            background-color: #e8f4f8;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
            text-align: center;
            font-size: 12px;
            color: #888;
        }
        .alert {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Payment Notification</h1>
        </div>
        
        <div class="content">
            <p>Hello Admin,</p>
            
            <p>A student has submitted a payment notification that requires your review and verification.</p>
            
            <div class="student-info">
                <h3 style="margin-top: 0;">Student Information:</h3>
                <p><strong>Name:</strong> {{ $student->name }}</p>
                <p><strong>School ID:</strong> {{ $student->school_id }}</p>
                <p><strong>Email:</strong> {{ $student->email }}</p>
                @if($student->phone)
                <p><strong>Phone:</strong> {{ $student->phone }}</p>
                @endif
            </div>
            
            <div class="payment-details">
                <h3>Payment Details:</h3>
                <p><strong>Transaction ID:</strong> {{ $transactionId }}</p>
                <p><strong>Amount Paid:</strong> ₵{{ number_format($amount, 2) }}</p>
                @if($paymentMethod)
                <p><strong>Payment Method:</strong> {{ $paymentMethod }}</p>
                @endif
                <p><strong>Date:</strong> {{ now()->format('F d, Y h:i A') }}</p>
            </div>
            
            <div class="alert">
                <strong>⚠️ Action Required:</strong> Please verify this transaction ID and update the student's payment record accordingly in the admin panel.
            </div>
            
            <p>Please log in to the admin panel to verify and process this payment.</p>
            
            <p>Best regards,<br>
            <strong>{{ $systemName }} System</strong></p>
        </div>
        
        <div class="footer">
            <p>This is an automated email notification from {{ $systemName }}.</p>
            <p>&copy; {{ date('Y') }} {{ $systemName }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

