@extends('layouts.app')

@section('title', 'Reset Password')

@section('content')
<div class="card" style="max-width: 450px; margin: 0 auto;">
    <div class="text-center mb-4">
        <h1 style="color: #4a9eff; margin-bottom: 10px;">{{ \App\Models\Setting::get('system_name', 'Afrilen Technologies') }}</h1>
        <h2 style="color: #e0e0e0; font-size: 24px;">Reset Password</h2>
        <p style="color: #888; margin-top: 10px;">Enter your new password below</p>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul style="list-style: none; margin: 0; padding: 0;">
                @foreach ($errors->all() as $error)
                    <li><i class="fas fa-exclamation-circle"></i> {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('password.update') }}">
        @csrf

        <input type="hidden" name="token" value="{{ $token }}">
        <input type="hidden" name="email" value="{{ $email }}">
        <input type="hidden" name="role" value="{{ $role ?? 'student' }}">

        <div class="form-group">
            <label for="email">Email Address</label>
            <input 
                type="email" 
                id="email" 
                name="email" 
                value="{{ $email }}" 
                readonly
                style="background: #2d2d2d; cursor: not-allowed;"
            >
        </div>

        <div class="form-group">
            <label for="password">New Password *</label>
            <input 
                type="password" 
                id="password" 
                name="password" 
                required
                minlength="8"
                placeholder="Enter your new password"
            >
            <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">
                Password must be at least 8 characters long.
            </small>
        </div>

        <div class="form-group">
            <label for="password_confirmation">Confirm New Password *</label>
            <input 
                type="password" 
                id="password_confirmation" 
                name="password_confirmation" 
                required
                minlength="8"
                placeholder="Confirm your new password"
            >
        </div>

        <button type="submit" class="btn btn-primary" style="width: 100%;">
            <i class="fas fa-key"></i> Reset Password
        </button>
    </form>

    <div class="text-center" style="margin-top: 20px;">
        <a href="{{ 
            isset($role) && $role === 'admin' ? route('admin.login') : 
            (isset($role) && $role === 'instructor' ? route('instructor.login') : route('student.login')) 
        }}">
            <i class="fas fa-arrow-left"></i> Back to Login
        </a>
    </div>
</div>
@endsection

