@extends('layouts.app')

@section('title', 'Reset Password')

@section('content')
<div class="card" style="max-width: 450px; margin: 0 auto;">
    <div class="text-center mb-4">
        <h1 style="color: #4a9eff; margin-bottom: 10px;">{{ \App\Models\Setting::get('system_name', 'Afrilen Technologies') }}</h1>
        <h2 style="color: #e0e0e0; font-size: 24px;">Reset Password</h2>
        <p style="color: #888; margin-top: 10px;">
            @if(isset($role) && $role === 'admin')
                Admin Password Reset
            @elseif(isset($role) && $role === 'instructor')
                Instructor Password Reset
            @else
                Student Password Reset
            @endif
        </p>
    </div>

    @if (session('status'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> {{ session('status') }}
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul style="list-style: none; margin: 0; padding: 0;">
                @foreach ($errors->all() as $error)
                    <li><i class="fas fa-exclamation-circle"></i> {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('password.email') }}">
        @csrf
        <input type="hidden" name="role" value="{{ $role ?? 'student' }}">

        <div class="form-group">
            <label for="email">Email Address *</label>
            <input 
                type="email" 
                id="email" 
                name="email" 
                value="{{ old('email') }}" 
                required 
                autofocus
                placeholder="Enter your email address"
            >
            <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">
                Enter your email address and we'll send you a link to reset your password.
            </small>
        </div>

        <button type="submit" class="btn btn-primary" style="width: 100%;">
            <i class="fas fa-paper-plane"></i> Send Password Reset Link
        </button>
    </form>

    <div class="text-center" style="margin-top: 20px;">
        <a href="{{ 
            isset($role) && $role === 'admin' ? route('admin.login') : 
            (isset($role) && $role === 'instructor' ? route('instructor.login') : route('student.login')) 
        }}">
            <i class="fas fa-arrow-left"></i> Back to Login
        </a>
    </div>
</div>
@endsection

