@extends('layouts.app')

@section('title', 'Login')

@section('content')
<div class="card" style="max-width: 450px; margin: 0 auto;">
    <div class="text-center mb-4">
        <h1 style="color: #4a9eff; margin-bottom: 10px;">Afrilen Technologies</h1>
        <h2 style="color: #e0e0e0; font-size: 24px;">School Portal</h2>
        <p style="color: #888; margin-top: 10px;">
            @if(isset($role) && $role === 'admin')
                Admin Login
            @elseif(isset($role) && $role === 'instructor')
                Instructor Login
            @else
                Student Login
            @endif
        </p>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul style="list-style: none; margin: 0; padding: 0;">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <form method="POST" action="{{ 
        isset($role) && $role === 'admin' ? route('admin.login.post') : 
        (isset($role) && $role === 'instructor' ? route('instructor.login.post') : route('login.post'))
    }}">
        @csrf

        <input type="hidden" name="role" value="{{ $role ?? 'student' }}">

        <div class="form-group">
            <label for="login" id="login-label">
                @if(isset($role) && $role === 'student')
                    School ID
                @else
                    Email Address
                @endif
            </label>
            <input 
                type="text" 
                id="login" 
                name="login" 
                value="{{ old('login') }}" 
                required 
                autofocus
                placeholder="{{ isset($role) && $role === 'student' ? 'Enter your school ID' : 'Enter your email' }}"
            >
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input 
                type="password" 
                id="password" 
                name="password" 
                required
                placeholder="Enter your password"
            >
        </div>

        <div class="remember-me">
            <input type="checkbox" name="remember" id="remember">
            <label for="remember">Remember me</label>
        </div>

        <button type="submit" class="btn btn-primary">
            Login
        </button>
    </form>

    <div class="text-center" style="margin-top: 20px;">
        <a href="{{ route('password.request', ['role' => $role ?? 'student']) }}">
            <i class="fas fa-key"></i> Forgot your password?
        </a>
    </div>

    @if(!isset($role) || $role === 'student')
    <div class="text-center" style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
        <p style="color: #888; font-size: 14px;">
            Are you an admin or instructor? 
            <a href="{{ route('admin.login') }}" style="margin-left: 5px;">Admin Login</a> | 
            <a href="{{ route('instructor.login') }}">Instructor Login</a>
        </p>
    </div>
    @endif
</div>
@endsection
