@extends('layouts.admin')

@section('title', 'Students')
@section('page-title', 'Student Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Students</h3>
            <a href="{{ route('admin.students.create') }}" class="btn btn-primary">Add New Student</a>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.students.index') }}" style="display: flex; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, school ID, or phone..." 
                    value="{{ request('search') }}"
                    style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request('search'))
                    <a href="{{ route('admin.students.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Students Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($students->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>School ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($students as $student)
                            <tr>
                                <td><strong>{{ $student->school_id }}</strong></td>
                                <td>{{ $student->name }}</td>
                                <td>{{ $student->email }}</td>
                                <td>{{ $student->phone ?? 'N/A' }}</td>
                                <td>{{ $student->created_at->format('M d, Y') }}</td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.students.show', $student->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.students.edit', $student->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Student', 'Are you sure you want to delete {{ addslashes($student->name) }}? This action cannot be undone.', '{{ route('admin.students.destroy', $student->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $students->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No students found.</p>
                    <a href="{{ route('admin.students.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Student</a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('styles')
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
@endsection

