@extends('layouts.admin')

@section('title', 'Edit Student')
@section('page-title', 'Edit Student')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Student: {{ $student->name }}</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.students.update', $student->id) }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            value="{{ old('name', $student->name) }}" 
                            required
                            autofocus
                            placeholder="Enter full name"
                        >
                        @error('name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input 
                            type="email" 
                            id="email" 
                            name="email" 
                            value="{{ old('email', $student->email) }}" 
                            required
                            placeholder="Enter email address"
                        >
                        @error('email')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="school_id">School ID *</label>
                        <input 
                            type="text" 
                            id="school_id" 
                            name="school_id" 
                            value="{{ old('school_id', $student->school_id) }}" 
                            required
                            placeholder="Enter unique school ID"
                        >
                        @error('school_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input 
                            type="text" 
                            id="phone" 
                            name="phone" 
                            value="{{ old('phone', $student->phone) }}" 
                            placeholder="Enter phone number"
                        >
                        @error('phone')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="address">Address</label>
                    <textarea 
                        id="address" 
                        name="address" 
                        rows="3"
                        placeholder="Enter address"
                        style="width: 100%; padding: 12px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; font-size: 16px; color: #e0e0e0; font-family: inherit; resize: vertical;"
                    >{{ old('address', $student->address) }}</textarea>
                    @error('address')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <!-- Course Enrollment Section -->
                @if($courses->count() > 0)
                <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px;">Course Enrollment</h4>
                    <div class="form-group">
                        <label>Select Courses to Enroll Student</label>
                        <div style="max-height: 200px; overflow-y: auto; border: 1px solid #404040; border-radius: 5px; padding: 10px; background: #1a1a1a;">
                            @foreach($courses as $course)
                                <label style="display: flex; align-items: center; padding: 8px; cursor: pointer; margin-bottom: 5px;">
                                    <input 
                                        type="checkbox" 
                                        name="courses[]" 
                                        value="{{ $course->id }}"
                                        style="margin-right: 10px; width: auto;"
                                        {{ in_array($course->id, old('courses', $enrolledCourseIds)) ? 'checked' : '' }}
                                    >
                                    <div style="flex: 1;">
                                        <strong style="color: #e0e0e0;">{{ $course->name }}</strong>
                                        <span style="color: #888; font-size: 12px; margin-left: 10px;">({{ $course->code }})</span>
                                        <div style="color: #888; font-size: 11px; margin-top: 2px;">
                                            Instructor: {{ $course->instructor->name ?? 'N/A' }} | 
                                            Fees: ${{ number_format($course->fees, 2) }}
                                        </div>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                        @error('courses')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                @endif
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 30px;">
                    <div class="form-group">
                        <label for="password">New Password (leave blank to keep current)</label>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            placeholder="Enter new password (min. 8 characters)"
                        >
                        @error('password')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password_confirmation">Confirm New Password</label>
                        <input 
                            type="password" 
                            id="password_confirmation" 
                            name="password_confirmation" 
                            placeholder="Confirm new password"
                        >
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Update Student</button>
                    <a href="{{ route('admin.students.index') }}" class="btn btn-secondary">Cancel</a>
                    <a href="{{ route('admin.students.show', $student->id) }}" class="btn btn-secondary">View Details</a>
                </div>
            </form>
        </div>
    </div>
@endsection

