@extends('layouts.admin')

@section('title', 'Settings')
@section('page-title', 'System Settings')

@section('content')
    <!-- General Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-cog"></i> General Settings</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="{{ route('admin.settings.update') }}">
                @csrf
                @method('PUT')
                <input type="hidden" name="group" value="general">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="system_name">System Name *</label>
                        <input 
                            type="text" 
                            id="system_name" 
                            name="system_name" 
                            value="{{ old('system_name', \App\Models\Setting::get('system_name', 'Afrilen Technologies')) }}" 
                            required
                            placeholder="e.g., Afrilen Technologies"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">The name of your application/system</small>
                        @error('system_name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="system_email">System Email *</label>
                        <input 
                            type="email" 
                            id="system_email" 
                            name="system_email" 
                            value="{{ old('system_email', \App\Models\Setting::get('system_email', 'noreply@afrilen.com')) }}" 
                            required
                            placeholder="noreply@afrilen.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Default system email address</small>
                        @error('system_email')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="system_phone">System Phone</label>
                        <input 
                            type="text" 
                            id="system_phone" 
                            name="system_phone" 
                            value="{{ old('system_phone', \App\Models\Setting::get('system_phone', '')) }}" 
                            placeholder="+233 XX XXX XXXX"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Contact phone number</small>
                        @error('system_phone')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="system_description">System Description</label>
                    <textarea 
                        id="system_description" 
                        name="system_description" 
                        rows="3"
                        placeholder="Brief description of your system"
                    >{{ old('system_description', \App\Models\Setting::get('system_description', '')) }}</textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Brief description of the system</small>
                    @error('system_description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="system_address">System Address</label>
                    <textarea 
                        id="system_address" 
                        name="system_address" 
                        rows="2"
                        placeholder="Physical address"
                    >{{ old('system_address', \App\Models\Setting::get('system_address', '')) }}</textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Physical address</small>
                    @error('system_address')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save General Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Email/SMTP Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-envelope"></i> Email / SMTP Settings</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="{{ route('admin.settings.update') }}">
                @csrf
                @method('PUT')
                <input type="hidden" name="group" value="email">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="mail_mailer">Mail Driver *</label>
                        <select id="mail_mailer" name="mail_mailer" required>
                            <option value="smtp" {{ \App\Models\Setting::get('mail_mailer', 'smtp') == 'smtp' ? 'selected' : '' }}>SMTP</option>
                            <option value="mailgun" {{ \App\Models\Setting::get('mail_mailer') == 'mailgun' ? 'selected' : '' }}>Mailgun</option>
                            <option value="ses" {{ \App\Models\Setting::get('mail_mailer') == 'ses' ? 'selected' : '' }}>Amazon SES</option>
                            <option value="postmark" {{ \App\Models\Setting::get('mail_mailer') == 'postmark' ? 'selected' : '' }}>Postmark</option>
                            <option value="sendmail" {{ \App\Models\Setting::get('mail_mailer') == 'sendmail' ? 'selected' : '' }}>Sendmail</option>
                        </select>
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Email delivery method</small>
                        @error('mail_mailer')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_host">SMTP Host *</label>
                        <input 
                            type="text" 
                            id="mail_host" 
                            name="mail_host" 
                            value="{{ old('mail_host', \App\Models\Setting::get('mail_host', '')) }}" 
                            required
                            placeholder="smtp.gmail.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">SMTP server address</small>
                        @error('mail_host')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_port">SMTP Port *</label>
                        <input 
                            type="text" 
                            id="mail_port" 
                            name="mail_port" 
                            value="{{ old('mail_port', \App\Models\Setting::get('mail_port', '587')) }}" 
                            required
                            placeholder="587"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Common ports: 587 (TLS), 465 (SSL), 25</small>
                        @error('mail_port')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_username">SMTP Username</label>
                        <input 
                            type="text" 
                            id="mail_username" 
                            name="mail_username" 
                            value="{{ old('mail_username', \App\Models\Setting::get('mail_username', '')) }}" 
                            placeholder="your-email@gmail.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">SMTP authentication username</small>
                        @error('mail_username')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_password">SMTP Password</label>
                        <input 
                            type="password" 
                            id="mail_password" 
                            name="mail_password" 
                            value=""
                            placeholder="Leave blank to keep current password"
                            autocomplete="new-password"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Leave blank to keep current password</small>
                        @error('mail_password')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_encryption">Encryption</label>
                        <select id="mail_encryption" name="mail_encryption">
                            <option value="tls" {{ \App\Models\Setting::get('mail_encryption', 'tls') == 'tls' ? 'selected' : '' }}>TLS</option>
                            <option value="ssl" {{ \App\Models\Setting::get('mail_encryption') == 'ssl' ? 'selected' : '' }}>SSL</option>
                            <option value="null" {{ \App\Models\Setting::get('mail_encryption') == 'null' ? 'selected' : '' }}>None</option>
                        </select>
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Encryption method</small>
                        @error('mail_encryption')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_from_address">From Email Address *</label>
                        <input 
                            type="email" 
                            id="mail_from_address" 
                            name="mail_from_address" 
                            value="{{ old('mail_from_address', \App\Models\Setting::get('mail_from_address', 'noreply@afrilen.com')) }}" 
                            required
                            placeholder="noreply@afrilen.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Email address to send from</small>
                        @error('mail_from_address')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_from_name">From Name *</label>
                        <input 
                            type="text" 
                            id="mail_from_name" 
                            name="mail_from_name" 
                            value="{{ old('mail_from_name', \App\Models\Setting::get('mail_from_name', 'Afrilen Technologies')) }}" 
                            required
                            placeholder="Afrilen Technologies"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Display name for emails</small>
                        @error('mail_from_name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #404040;">
                    <div class="form-group">
                        <label for="test_email_address">Test Email Configuration</label>
                        <div style="display: flex; gap: 10px; align-items: flex-end;">
                            <div style="flex: 1;">
                                <input 
                                    type="email" 
                                    id="test_email_address" 
                                    name="test_email_address" 
                                    value="{{ old('test_email_address') }}" 
                                    placeholder="Enter email address to test"
                                >
                                <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Send a test email to verify configuration</small>
                            </div>
                            <button type="button" onclick="testEmail()" class="btn btn-secondary" style="white-space: nowrap;">
                                <i class="fas fa-paper-plane"></i> Send Test Email
                            </button>
                        </div>
                        @if(session('email_test_error'))
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ session('email_test_error') }}</span>
                        @endif
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Email Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    @push('scripts')
    <script>
        function testEmail() {
            const email = document.getElementById('test_email_address').value;
            
            if (!email) {
                alert('Please enter an email address to test');
                return;
            }
            
            if (!confirm('This will send a test email to ' + email + '. Continue?')) {
                return;
            }
            
            // Create form data
            const formData = new FormData();
            formData.append('_token', '{{ csrf_token() }}');
            formData.append('test_email_address', email);
            
            // Show loading
            const btn = event.target.closest('button');
            const originalText = btn.innerHTML;
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            
            fetch('{{ route('admin.settings.test-email') }}', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                btn.disabled = false;
                btn.innerHTML = originalText;
                
                if (data.success) {
                    alert('Test email sent successfully! Please check your inbox.');
                } else {
                    alert('Error: ' + (data.message || 'Failed to send test email'));
                }
            })
            .catch(error => {
                btn.disabled = false;
                btn.innerHTML = originalText;
                console.error('Error:', error);
                alert('Error: Failed to send test email. Please check your SMTP settings.');
            });
        }
    </script>
    @endpush

    <!-- Payment Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-money-bill-wave"></i> Payment Information</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="{{ route('admin.settings.update') }}">
                @csrf
                @method('PUT')
                <input type="hidden" name="group" value="payment">
                
                <div class="form-group">
                    <label for="payment_info">Payment Instructions *</label>
                    <textarea 
                        id="payment_info" 
                        name="payment_info" 
                        rows="12"
                        placeholder="Enter payment instructions that will be shown to students when they want to make a payment. Include bank details, mobile money numbers, account numbers, etc."
                        style="width: 100%; padding: 12px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0; font-family: inherit; white-space: pre-line;"
                    >{{ old('payment_info', \App\Models\Setting::get('payment_info', '💳 Payment Methods

Merchant Number (Recommended):
📌 054 505 4754 — IKSOFT TECHNOLOGIES

MTN MoMo:
📌 0543261734 — ADU AMANKWAH ISAAC
📌 0550138086 — AGYEKUM MARY

Telecel Cash:
📌 0206934488 — ADU AMANKWAH ISAAC')) }}</textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">
                        This information will be displayed to students in the payment modal. Include bank details, mobile money numbers, account numbers, etc.
                    </small>
                    @error('payment_info')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Payment Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

