@extends('layouts.admin')

@section('title', 'Resources')
@section('page-title', 'Resources Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Resources</h3>
            <a href="{{ route('admin.resources.create') }}" class="btn btn-primary">
                <i class="fas fa-upload"></i> Upload New Resource
            </a>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.resources.index') }}" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <input type="text" name="search" placeholder="Search resources..." value="{{ request('search') }}" style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request('search') || request('status'))
                    <a href="{{ route('admin.resources.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($resources->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Type</th>
                            <th>File</th>
                            <th>Size</th>
                            <th>Accessible By</th>
                            <th>Uploaded By</th>
                            <th>Downloads</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($resources as $resource)
                            <tr>
                                <td>
                                    <strong>{{ $resource->title }}</strong>
                                    @if($resource->description)
                                        <br><small style="color: #888;">{{ Str::limit($resource->description, 50) }}</small>
                                    @endif
                                </td>
                                <td>{{ $resource->resource_type ?? 'N/A' }}</td>
                                <td>
                                    <i class="fas fa-file" style="color: #4a9eff;"></i>
                                    <small>{{ $resource->file_extension ?? 'N/A' }}</small>
                                </td>
                                <td>{{ $resource->formatted_file_size }}</td>
                                <td>
                                    @foreach($resource->accessible_by_roles ?? [] as $role)
                                        <span style="display: inline-block; padding: 2px 8px; background: #2d2d2d; border-radius: 3px; font-size: 11px; margin: 2px;">
                                            {{ ucfirst($role) }}
                                        </span>
                                    @endforeach
                                </td>
                                <td>{{ $resource->uploader->name ?? 'N/A' }}</td>
                                <td>{{ $resource->download_count }}</td>
                                <td>
                                    @if($resource->is_active)
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                                        <a href="{{ route('admin.resources.show', $resource->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.resources.edit', $resource->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <a href="{{ route('admin.resources.download', $resource->id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                        <form action="{{ route('admin.resources.destroy', $resource->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this resource?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger" style="padding: 6px 12px; font-size: 12px;">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div style="margin-top: 20px;">{{ $resources->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <i class="fas fa-folder-open" style="font-size: 48px; margin-bottom: 15px; color: #404040;"></i>
                    <p>No resources found.</p>
                    <a href="{{ route('admin.resources.create') }}" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-upload"></i> Upload First Resource
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

