@extends('layouts.admin')

@section('title', 'Edit Resource')
@section('page-title', 'Edit Resource')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Resource</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.resources.update', $resource->id) }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label for="title">Resource Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title', $resource->title) }}" 
                        required
                        autofocus
                        placeholder="e.g., Course Material - Flutter Basics"
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="resource_type">What is this resource? (Optional)</label>
                    <input 
                        type="text" 
                        id="resource_type" 
                        name="resource_type" 
                        value="{{ old('resource_type', $resource->resource_type) }}" 
                        placeholder="e.g., Course Material, Assignment Template, Study Guide, Reference Document"
                    >
                    @error('resource_type')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="description">Description (Optional)</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Provide a detailed description of this resource..."
                    >{{ old('description', $resource->description) }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label>Current File</label>
                    <div style="background: #1a1a1a; padding: 15px; border-radius: 5px; margin-top: 10px;">
                        <strong>{{ $resource->file_name }}</strong>
                        <small style="display: block; color: #888; margin-top: 5px;">
                            {{ $resource->formatted_file_size }} | {{ strtoupper($resource->file_extension ?? 'N/A') }}
                        </small>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="file">Replace File (Optional)</label>
                    <input 
                        type="file" 
                        id="file" 
                        name="file" 
                        accept="*/*"
                    >
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Leave empty to keep current file. Maximum file size: 100MB. All file formats are accepted.
                    </small>
                    @error('file')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label>Who can access this resource? *</label>
                    <div style="display: flex; gap: 20px; margin-top: 10px; flex-wrap: wrap;">
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="admin"
                                {{ in_array('admin', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : '' }}
                            >
                            <span>Admin</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="instructor"
                                {{ in_array('instructor', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : '' }}
                            >
                            <span>Instructor</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="student"
                                {{ in_array('student', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : '' }}
                            >
                            <span>Student</span>
                        </label>
                    </div>
                    @error('accessible_by_roles')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                    @error('accessible_by_roles.*')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            name="is_active" 
                            value="1"
                            {{ old('is_active', $resource->is_active) ? 'checked' : '' }}
                        >
                        <span>Active (Resource will be visible to users)</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Resource
                    </button>
                    <a href="{{ route('admin.resources.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

