@extends('layouts.admin')

@section('title', 'Upload Resource')
@section('page-title', 'Upload New Resource')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Upload New Resource</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.resources.store') }}" enctype="multipart/form-data">
                @csrf
                
                <div class="form-group">
                    <label for="title">Resource Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title') }}" 
                        required
                        autofocus
                        placeholder="e.g., Course Material - Flutter Basics"
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="resource_type">What is this resource? (Optional)</label>
                    <input 
                        type="text" 
                        id="resource_type" 
                        name="resource_type" 
                        value="{{ old('resource_type') }}" 
                        placeholder="e.g., Course Material, Assignment Template, Study Guide, Reference Document"
                    >
                    @error('resource_type')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="description">Description (Optional)</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Provide a detailed description of this resource..."
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="file">Resource File *</label>
                    <input 
                        type="file" 
                        id="file" 
                        name="file" 
                        required
                        accept="*/*"
                    >
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Maximum file size: 100MB. All file formats are accepted.
                    </small>
                    @error('file')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label>Who can access this resource? *</label>
                    <div style="display: flex; gap: 20px; margin-top: 10px; flex-wrap: wrap;">
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="admin"
                                {{ in_array('admin', old('accessible_by_roles', [])) ? 'checked' : '' }}
                            >
                            <span>Admin</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="instructor"
                                {{ in_array('instructor', old('accessible_by_roles', [])) ? 'checked' : '' }}
                            >
                            <span>Instructor</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="student"
                                {{ in_array('student', old('accessible_by_roles', [])) ? 'checked' : '' }}
                            >
                            <span>Student</span>
                        </label>
                    </div>
                    @error('accessible_by_roles')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                    @error('accessible_by_roles.*')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Upload Resource
                    </button>
                    <a href="{{ route('admin.resources.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

