@extends('layouts.admin')

@section('title', 'Quiz Management')
@section('page-title', 'Quiz Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
            <h3>All Quizzes</h3>
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.quizzes.import') }}" class="btn btn-secondary">
                    <i class="fas fa-upload"></i> Import Quiz
                </a>
                <a href="{{ route('admin.quizzes.template.download') }}" class="btn btn-secondary">
                    <i class="fas fa-download"></i> Download Template
                </a>
                <a href="{{ route('admin.quizzes.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create New Quiz
                </a>
            </div>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.quizzes.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <select name="level" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Levels</option>
                    <option value="1" {{ request('level') == '1' ? 'selected' : '' }}>Beginner</option>
                    <option value="2" {{ request('level') == '2' ? 'selected' : '' }}>Intermediate</option>
                    <option value="3" {{ request('level') == '3' ? 'selected' : '' }}>Advanced</option>
                </select>
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                            {{ $course->name }}
                        </option>
                    @endforeach
                </select>
                <select name="book_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Books</option>
                    @foreach($books as $book)
                        <option value="{{ $book->id }}" {{ request('book_id') == $book->id ? 'selected' : '' }}>
                            {{ $book->title }}
                        </option>
                    @endforeach
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request()->anyFilled(['level', 'course_id', 'book_id']))
                    <a href="{{ route('admin.quizzes.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Quizzes Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($quizzes->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Level</th>
                            <th>Questions</th>
                            <th>Course/Book</th>
                            <th>Created By</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($quizzes as $quiz)
                            <tr>
                                <td><strong>{{ $quiz->title }}</strong></td>
                                <td>
                                    <span style="padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold;
                                        @if($quiz->level == 1)
                                            background: #1a3a1a; color: #6bff6b;
                                        @elseif($quiz->level == 2)
                                            background: #3a3a1a; color: #ffa500;
                                        @else
                                            background: #3a1a1a; color: #ff6b6b;
                                        @endif
                                    ">
                                        {{ $quiz->level_name }}
                                    </span>
                                </td>
                                <td>{{ $quiz->total_questions }}</td>
                                <td>
                                    @if($quiz->course)
                                        <i class="fas fa-book"></i> {{ $quiz->course->name }}
                                    @elseif($quiz->book)
                                        <i class="fas fa-book-open"></i> {{ $quiz->book->title }}
                                    @else
                                        <span style="color: #888;">N/A</span>
                                    @endif
                                </td>
                                <td>{{ $quiz->creator ? $quiz->creator->name : 'N/A' }}</td>
                                <td>
                                    @if($quiz->is_active)
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.quizzes.edit', $quiz->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <button type="button" onclick="openConfirmationModal('Delete Quiz', 'Are you sure you want to delete this quiz? This action cannot be undone.', '{{ route('admin.quizzes.destroy', $quiz->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <div style="margin-top: 20px;">
                    {{ $quizzes->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 60px 20px; color: #888;">
                    <i class="fas fa-question-circle" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                    <p style="font-size: 18px; margin-bottom: 10px;">No quizzes found</p>
                    <p style="font-size: 14px; margin-bottom: 20px;">Create your first quiz to get started!</p>
                    <a href="{{ route('admin.quizzes.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Quiz
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

