@extends('layouts.admin')

@section('title', 'Import Quiz')
@section('page-title', 'Import Quiz from JSON')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>Import Quiz from JSON</h3>
            <a href="{{ route('admin.quizzes.template.download') }}" class="btn btn-secondary">
                <i class="fas fa-download"></i> Download Template
            </a>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <div style="background: #2d2d2d; padding: 20px; border-radius: 8px; margin-bottom: 30px; border: 1px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">
                    <i class="fas fa-info-circle"></i> Instructions
                </h4>
                <ol style="color: #888; line-height: 2; padding-left: 20px;">
                    <li>Download the JSON template using the button above</li>
                    <li>Fill in the quiz information and questions</li>
                    <li>Ensure each question has at least 2 answers</li>
                    <li>Mark one answer as correct for each question (is_correct: true)</li>
                    <li>Upload the completed JSON file below</li>
                </ol>
            </div>
            
            <form method="POST" action="{{ route('admin.quizzes.import.store') }}" enctype="multipart/form-data">
                @csrf
                
                <div class="form-group">
                    <label for="json_file">JSON File *</label>
                    <input type="file" id="json_file" name="json_file" accept=".json,.txt" required>
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Select a JSON file with quiz data
                    </small>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course (Optional - overrides JSON)</label>
                        <select id="course_id" name="course_id">
                            <option value="">None</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}">{{ $course->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="book_id">Book (Optional - overrides JSON)</label>
                        <select id="book_id" name="book_id">
                            <option value="">None</option>
                            @foreach($books as $book)
                                <option value="{{ $book->id }}">{{ $book->title }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Import Quiz
                    </button>
                    <a href="{{ route('admin.quizzes.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

