@extends('layouts.admin')

@section('title', 'Create Quiz')
@section('page-title', 'Create New Quiz')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Create New Quiz</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.quizzes.store') }}">
                @csrf
                
                <div class="form-group">
                    <label for="title">Quiz Title *</label>
                    <input type="text" id="title" name="title" value="{{ old('title') }}" required>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea id="description" name="description" rows="3">{{ old('description') }}</textarea>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="level">Level *</label>
                        <select id="level" name="level" required>
                            <option value="1" {{ old('level') == '1' ? 'selected' : '' }}>Beginner</option>
                            <option value="2" {{ old('level') == '2' ? 'selected' : '' }}>Intermediate</option>
                            <option value="3" {{ old('level') == '3' ? 'selected' : '' }}>Advanced</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_id">Course (Optional)</label>
                        <select id="course_id" name="course_id">
                            <option value="">None</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                    {{ $course->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="book_id">Book (Optional)</label>
                        <select id="book_id" name="book_id">
                            <option value="">None</option>
                            @foreach($books as $book)
                                <option value="{{ $book->id }}" {{ old('book_id') == $book->id ? 'selected' : '' }}>
                                    {{ $book->title }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="time_limit_minutes">Time Limit (Minutes, Optional)</label>
                        <input type="number" id="time_limit_minutes" name="time_limit_minutes" value="{{ old('time_limit_minutes') }}" min="1" placeholder="e.g., 30">
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Leave empty for no time limit</small>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <span>Active (visible to students)</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Create Quiz</button>
                    <a href="{{ route('admin.quizzes.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

