@extends('layouts.admin')

@section('title', 'Instructor Details')
@section('page-title', 'Instructor Details')

@section('content')
    <div style="display: flex; gap: 15px; margin-bottom: 20px;">
        <a href="{{ route('admin.instructors.index') }}" class="btn btn-secondary">← Back to List</a>
        <a href="{{ route('admin.instructors.edit', $instructor->id) }}" class="btn btn-primary">Edit Instructor</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $instructor->name }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Personal Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Full Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->name }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Email Address</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->email }}</span>
                    </div>
                    @if($instructor->phone)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Phone Number</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->phone }}</span>
                    </div>
                    @endif
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Additional Information</h4>
                    @if($instructor->address)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Address</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->address }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Account Status</strong>
                        <span style="color: #6bff6b; font-size: 16px; font-weight: 600;">Active</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Registered On</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->created_at->format('F d, Y h:i A') }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Last Updated</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $instructor->updated_at->format('F d, Y h:i A') }}</span>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040; display: flex; gap: 15px;">
                <a href="{{ route('admin.instructors.edit', $instructor->id) }}" class="btn btn-primary">Edit Instructor</a>
                <button type="button" onclick="openConfirmationModal('Delete Instructor', 'Are you sure you want to delete {{ addslashes($instructor->name) }}? This action cannot be undone and all associated data will be permanently removed.', '{{ route('admin.instructors.destroy', $instructor->id) }}', 'DELETE')" class="btn btn-secondary" style="background: #dc3545; border: none;">
                    <i class="fas fa-trash"></i> Delete Instructor
                </button>
            </div>
        </div>
    </div>
    
    <!-- Assigned Courses Section -->
    <div class="card" style="margin-top: 20px;">
        <div class="card-header">
            <h3>Assigned Courses ({{ $courses->count() }})</h3>
        </div>
        <div style="padding: 30px;">
            @if($courses->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Course Code</th>
                            <th>Course Name</th>
                            <th>Credits</th>
                            <th>Fees</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($courses as $course)
                            <tr>
                                <td><strong>{{ $course->code }}</strong></td>
                                <td>{{ $course->name }}</td>
                                <td>{{ $course->credits }}</td>
                                <td>${{ number_format($course->fees, 2) }}</td>
                                <td>
                                    @if($course->is_active)
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p style="color: #888; text-align: center; padding: 20px;">
                    No courses assigned to this instructor yet.
                </p>
            @endif
        </div>
    </div>
@endsection

