@extends('layouts.admin')

@section('title', 'Add Instructor')
@section('page-title', 'Add New Instructor')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Create New Instructor</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.instructors.store') }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            value="{{ old('name') }}" 
                            required
                            autofocus
                            placeholder="Enter full name"
                        >
                        @error('name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input 
                            type="email" 
                            id="email" 
                            name="email" 
                            value="{{ old('email') }}" 
                            required
                            placeholder="Enter email address"
                        >
                        @error('email')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input 
                            type="text" 
                            id="phone" 
                            name="phone" 
                            value="{{ old('phone') }}" 
                            placeholder="Enter phone number"
                        >
                        @error('phone')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="address">Address</label>
                    <textarea 
                        id="address" 
                        name="address" 
                        rows="3"
                        placeholder="Enter address"
                    >{{ old('address') }}</textarea>
                    @error('address')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <!-- Course Assignment Section -->
                <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px;">Course Assignment</h4>
                    
                    <!-- Select Existing Courses -->
                    @if($existingCourses->count() > 0)
                        <div class="form-group">
                            <label>Assign Existing Courses (Optional)</label>
                            <div style="max-height: 200px; overflow-y: auto; border: 1px solid #404040; border-radius: 5px; padding: 10px; background: #1a1a1a;">
                                @foreach($existingCourses as $course)
                                    <label style="display: flex; align-items: center; padding: 8px; cursor: pointer; margin-bottom: 5px;">
                                        <input 
                                            type="checkbox" 
                                            name="courses[]" 
                                            value="{{ $course->id }}"
                                            style="margin-right: 10px; width: auto;"
                                            {{ in_array($course->id, old('courses', [])) ? 'checked' : '' }}
                                        >
                                        <div>
                                            <strong style="color: #e0e0e0;">{{ $course->name }}</strong>
                                            <span style="color: #888; font-size: 12px; margin-left: 10px;">({{ $course->code }})</span>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                            @error('courses')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    @endif
                    
                    <!-- Add New Courses -->
                    <div class="form-group" style="margin-top: 20px;">
                        <label>Or Create New Courses for This Instructor</label>
                        <div id="courses-container">
                            <div class="course-row" style="background: #1a1a1a; padding: 15px; border-radius: 5px; margin-bottom: 10px; border: 1px solid #404040;">
                                <div style="display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 15px; align-items: end;">
                                    <div>
                                        <label style="font-size: 12px; color: #888;">Course Name *</label>
                                        <input type="text" name="new_courses[0][name]" placeholder="e.g., Introduction to Programming" style="margin-top: 5px;">
                                    </div>
                                    <div>
                                        <label style="font-size: 12px; color: #888;">Course Code *</label>
                                        <input type="text" name="new_courses[0][code]" placeholder="e.g., CS101" style="margin-top: 5px;">
                                    </div>
                                    <div>
                                        <label style="font-size: 12px; color: #888;">Credits</label>
                                        <input type="number" name="new_courses[0][credits]" value="0" min="0" style="margin-top: 5px;">
                                    </div>
                                    <div>
                                        <label style="font-size: 12px; color: #888;">Fees</label>
                                        <input type="number" name="new_courses[0][fees]" value="0.00" step="0.01" min="0" style="margin-top: 5px;">
                                    </div>
                                </div>
                                <div style="margin-top: 10px;">
                                    <label style="font-size: 12px; color: #888;">Description</label>
                                    <textarea name="new_courses[0][description]" rows="2" placeholder="Course description (optional)" style="margin-top: 5px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="button" onclick="addCourseRow()" class="btn btn-secondary" style="margin-top: 10px;">+ Add Another Course</button>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 30px;">
                    <div class="form-group">
                        <label for="password">Password *</label>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            required
                            placeholder="Enter password (min. 8 characters)"
                        >
                        @error('password')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password_confirmation">Confirm Password *</label>
                        <input 
                            type="password" 
                            id="password_confirmation" 
                            name="password_confirmation" 
                            required
                            placeholder="Confirm password"
                        >
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Create Instructor</button>
                    <a href="{{ route('admin.instructors.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    let courseRowIndex = 1;
    
    function addCourseRow() {
        const container = document.getElementById('courses-container');
        const newRow = document.createElement('div');
        newRow.className = 'course-row';
        newRow.style.cssText = 'background: #1a1a1a; padding: 15px; border-radius: 5px; margin-bottom: 10px; border: 1px solid #404040; position: relative;';
        
        newRow.innerHTML = `
            <button type="button" onclick="this.closest('.course-row').remove()" style="position: absolute; top: 10px; right: 10px; background: #dc3545; color: white; border: none; border-radius: 3px; padding: 5px 10px; cursor: pointer; font-size: 12px;">Remove</button>
            <div style="display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 15px; align-items: end;">
                <div>
                    <label style="font-size: 12px; color: #888;">Course Name *</label>
                    <input type="text" name="new_courses[${courseRowIndex}][name]" placeholder="e.g., Introduction to Programming" style="margin-top: 5px;" required>
                </div>
                <div>
                    <label style="font-size: 12px; color: #888;">Course Code *</label>
                    <input type="text" name="new_courses[${courseRowIndex}][code]" placeholder="e.g., CS101" style="margin-top: 5px;" required>
                </div>
                <div>
                    <label style="font-size: 12px; color: #888;">Credits</label>
                    <input type="number" name="new_courses[${courseRowIndex}][credits]" value="0" min="0" style="margin-top: 5px;">
                </div>
                <div>
                    <label style="font-size: 12px; color: #888;">Fees</label>
                    <input type="number" name="new_courses[${courseRowIndex}][fees]" value="0.00" step="0.01" min="0" style="margin-top: 5px;">
                </div>
            </div>
            <div style="margin-top: 10px;">
                <label style="font-size: 12px; color: #888;">Description</label>
                <textarea name="new_courses[${courseRowIndex}][description]" rows="2" placeholder="Course description (optional)" style="margin-top: 5px;"></textarea>
            </div>
        `;
        
        container.appendChild(newRow);
        courseRowIndex++;
    }
</script>
@endsection

