@extends('layouts.admin')

@section('title', 'Payment History')
@section('page-title', 'Payment History')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Fee Payments</h3>
            <div style="display: flex; gap: 20px; align-items: center;">
                <div style="text-align: right;">
                    <small style="color: #888; display: block;">Total Payments</small>
                    <strong style="color: #4a9eff; font-size: 18px;">₵{{ number_format($totalAmount, 2) }}</strong>
                </div>
                <div style="text-align: right;">
                    <small style="color: #888; display: block;">Actual Money at Hand</small>
                    <strong style="color: #6bff6b; font-size: 18px;">₵{{ number_format($actualMoneyAtHand, 2) }}</strong>
                </div>
            </div>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.fee-payments.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by student name or school ID..." 
                    value="{{ request('search') }}"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <input 
                    type="date" 
                    name="date_from" 
                    value="{{ request('date_from') }}"
                    placeholder="From Date"
                    style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <input 
                    type="date" 
                    name="date_to" 
                    value="{{ request('date_to') }}"
                    placeholder="To Date"
                    style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="payment_method" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Methods</option>
                    <option value="cash" {{ request('payment_method') == 'cash' ? 'selected' : '' }}>Cash</option>
                    <option value="bank_transfer" {{ request('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                    <option value="card" {{ request('payment_method') == 'card' ? 'selected' : '' }}>Card</option>
                    <option value="online" {{ request('payment_method') == 'online' ? 'selected' : '' }}>Online</option>
                </select>
                <select name="payment_status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="regular" {{ request('payment_status') == 'regular' ? 'selected' : '' }}>Regular</option>
                    <option value="scholarship" {{ request('payment_status') == 'scholarship' ? 'selected' : '' }}>Scholarship</option>
                    <option value="refunded" {{ request('payment_status') == 'refunded' ? 'selected' : '' }}>Refunded</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request()->anyFilled(['search', 'date_from', 'date_to', 'payment_method', 'payment_status']))
                    <a href="{{ route('admin.fee-payments.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Payments Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($payments->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Offering</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Status</th>
                            <th>Reference</th>
                            <th>Recorded By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payments as $payment)
                            <tr>
                                <td>{{ $payment->payment_date->format('M d, Y') }}</td>
                                <td><strong>{{ $payment->student->name }}</strong><br><small>{{ $payment->student->school_id ?? 'N/A' }}</small></td>
                                <td>{{ $payment->course->name ?? 'N/A' }}</td>
                                <td>{{ $payment->courseOffering->name ?? 'N/A' }}</td>
                                <td style="color: #6bff6b; font-weight: bold;">₵{{ number_format($payment->amount, 2) }}</td>
                                <td>{{ ucfirst(str_replace('_', ' ', $payment->payment_method)) }}</td>
                                <td>
                                    <span style="padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold;
                                        @if(($payment->payment_status ?? 'regular') == 'scholarship')
                                            background: #1a3a3a; color: #4a9eff;
                                        @elseif(($payment->payment_status ?? 'regular') == 'refunded')
                                            background: #3a1a1a; color: #ff6b6b;
                                        @else
                                            background: #1a3a1a; color: #6bff6b;
                                        @endif
                                    ">
                                        {{ ucfirst($payment->payment_status ?? 'regular') }}
                                    </span>
                                </td>
                                <td>{{ $payment->transaction_reference ?? 'N/A' }}</td>
                                <td>{{ $payment->recordedBy->name }}</td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.fee-payments.edit', $payment->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Payment', 'Are you sure you want to delete this payment record for {{ addslashes($payment->student->name) }}? This action cannot be undone.', '{{ route('admin.fee-payments.destroy', $payment->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <div style="margin-top: 20px;">
                    {{ $payments->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No payments found.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

