@extends('layouts.admin')

@section('title', 'Edit Payment')
@section('page-title', 'Edit Payment')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Payment</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.fee-payments.update', $payment->id) }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="student_id">Student *</label>
                        <select id="student_id" name="student_id" required>
                            <option value="">Select Student</option>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ (old('student_id', $payment->student_id) == $student->id) ? 'selected' : '' }}>
                                    {{ $student->name }} {{ $student->school_id ? '(' . $student->school_id . ')' : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_id">Course</label>
                        <select id="course_id" name="course_id">
                            <option value="">None</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ (old('course_id', $payment->course_id) == $course->id) ? 'selected' : '' }}>
                                    {{ $course->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">None</option>
                            @foreach($offerings as $offering)
                                <option value="{{ $offering->id }}" {{ (old('course_offering_id', $payment->course_offering_id) == $offering->id) ? 'selected' : '' }}>
                                    {{ $offering->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="amount">Amount *</label>
                        <input type="number" id="amount" name="amount" step="0.01" min="0.01" value="{{ old('amount', $payment->amount) }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_date">Payment Date *</label>
                        <input type="date" id="payment_date" name="payment_date" value="{{ old('payment_date', $payment->payment_date->format('Y-m-d')) }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_method">Payment Method *</label>
                        <select id="payment_method" name="payment_method" required>
                            <option value="cash" {{ old('payment_method', $payment->payment_method) == 'cash' ? 'selected' : '' }}>Cash</option>
                            <option value="bank_transfer" {{ old('payment_method', $payment->payment_method) == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="card" {{ old('payment_method', $payment->payment_method) == 'card' ? 'selected' : '' }}>Card</option>
                            <option value="online" {{ old('payment_method', $payment->payment_method) == 'online' ? 'selected' : '' }}>Online</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_status">Payment Status *</label>
                        <select id="payment_status" name="payment_status" required>
                            <option value="regular" {{ old('payment_status', $payment->payment_status ?? 'regular') == 'regular' ? 'selected' : '' }}>Regular Payment</option>
                            <option value="scholarship" {{ old('payment_status', $payment->payment_status ?? 'regular') == 'scholarship' ? 'selected' : '' }}>Scholarship</option>
                            <option value="refunded" {{ old('payment_status', $payment->payment_status ?? 'regular') == 'refunded' ? 'selected' : '' }}>Refunded</option>
                        </select>
                        <small style="color: #888; display: block; margin-top: 5px;">
                            Scholarship and Refunded payments don't count toward actual money at hand.
                        </small>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="transaction_reference">Transaction Reference</label>
                        <input type="text" id="transaction_reference" name="transaction_reference" value="{{ old('transaction_reference', $payment->transaction_reference) }}">
                    </div>
                    
                    <div class="form-group">
                        <label for="notes">Notes</label>
                        <textarea id="notes" name="notes" rows="3">{{ old('notes', $payment->notes) }}</textarea>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Update Payment</button>
                    <a href="{{ route('admin.fee-payments.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

