@extends('layouts.admin')

@section('title', 'Enrollment Details')
@section('page-title', 'Enrollment Details')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>Enrollment Details</h3>
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.enrollments.edit', $enrollment->id) }}" class="btn btn-secondary">Edit</a>
                <a href="{{ route('admin.enrollments.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Student</strong>
                    <p style="font-size: 16px;">{{ $enrollment->student->name }}</p>
                    <small>{{ $enrollment->student->school_id ?? 'N/A' }}</small>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                    <p style="font-size: 16px;">{{ $enrollment->course->name }}</p>
                    <small>{{ $enrollment->course->code }}</small>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course Offering</strong>
                    <p style="font-size: 16px;">{{ $enrollment->courseOffering->name ?? 'N/A' }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Enrollment Date</strong>
                    <p style="font-size: 16px;">{{ $enrollment->enrollment_date->format('M d, Y') }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                    @if($enrollment->status == 'active')
                        <span style="color: #6bff6b; font-weight: bold;">Active</span>
                    @elseif($enrollment->status == 'completed')
                        <span style="color: #888; font-weight: bold;">Completed</span>
                    @elseif($enrollment->status == 'withdrawn')
                        <span style="color: #ff6b6b; font-weight: bold;">Withdrawn</span>
                    @else
                        <span style="color: #888; font-weight: bold;">Inactive</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

