@extends('layouts.admin')

@section('title', 'Enrollments')
@section('page-title', 'Enrollments Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Enrollments</h3>
            <a href="{{ route('admin.enrollments.create') }}" class="btn btn-primary">Add New Enrollment</a>
        </div>
        
        <!-- Filters and Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.enrollments.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by student name or school ID..." 
                    value="{{ request('search') }}"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                            {{ $course->name }}
                        </option>
                    @endforeach
                </select>
                <select name="course_offering_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Offerings</option>
                    @foreach($offerings as $offering)
                        <option value="{{ $offering->id }}" {{ request('course_offering_id') == $offering->id ? 'selected' : '' }}>
                            {{ $offering->name }}
                        </option>
                    @endforeach
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                    <option value="withdrawn" {{ request('status') == 'withdrawn' ? 'selected' : '' }}>Withdrawn</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request()->anyFilled(['search', 'course_id', 'course_offering_id', 'status']))
                    <a href="{{ route('admin.enrollments.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Enrollments Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($enrollments->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Offering</th>
                            <th>Enrollment Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($enrollments as $enrollment)
                            <tr>
                                <td><strong>{{ $enrollment->student->name }}</strong><br><small>{{ $enrollment->student->school_id ?? 'N/A' }}</small></td>
                                <td>{{ $enrollment->course->name }}<br><small>{{ $enrollment->course->code }}</small></td>
                                <td>{{ $enrollment->courseOffering->name ?? 'N/A' }}</td>
                                <td>{{ $enrollment->enrollment_date->format('M d, Y') }}</td>
                                <td>
                                    @if($enrollment->status == 'active')
                                        <span style="color: #6bff6b;">Active</span>
                                    @elseif($enrollment->status == 'completed')
                                        <span style="color: #888;">Completed</span>
                                    @elseif($enrollment->status == 'withdrawn')
                                        <span style="color: #ff6b6b;">Withdrawn</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.enrollments.show', $enrollment->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.enrollments.edit', $enrollment->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Enrollment', 'Are you sure you want to delete this enrollment for {{ addslashes($enrollment->student->name) }} in {{ addslashes($enrollment->course->name) }}? This action cannot be undone.', '{{ route('admin.enrollments.destroy', $enrollment->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $enrollments->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No enrollments found.</p>
                    <a href="{{ route('admin.enrollments.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Enrollment</a>
                </div>
            @endif
        </div>
    </div>
@endsection

