@extends('layouts.admin')

@section('title', 'Course Details')
@section('page-title', 'Course Details')

@section('content')
    <div style="display: flex; gap: 15px; margin-bottom: 20px;">
        <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary">← Back to List</a>
        <a href="{{ route('admin.courses.edit', $course->id) }}" class="btn btn-primary">Edit Course</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $course->name }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Code</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;">{{ $course->code }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->name }}</span>
                    </div>
                    @if($course->description)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Description</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->description }}</span>
                    </div>
                    @endif
                    
                    @if($course->session_period || $course->number_of_weeks || $course->number_of_sessions)
                    <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #404040;">
                        <h5 style="color: #4a9eff; margin-bottom: 10px;">Academic Session</h5>
                        @if($course->session_period)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Period</strong>
                            <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;">{{ $course->session_period }}</span>
                        </div>
                        @endif
                        @if($course->number_of_weeks)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Duration</strong>
                            <span style="color: #e0e0e0; font-size: 16px;">{{ $course->number_of_weeks }} Weeks</span>
                            @if($course->number_of_sessions)
                                <span style="color: #888;">({{ $course->number_of_sessions }} Sessions)</span>
                            @endif
                        </div>
                        @endif
                        @if($course->schedule_days && count($course->schedule_days) > 0)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Days</strong>
                            <span style="color: #e0e0e0; font-size: 16px;">{{ implode(', ', $course->schedule_days) }}</span>
                        </div>
                        @endif
                        @if($course->start_time || $course->end_time)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Time</strong>
                            <span style="color: #e0e0e0; font-size: 16px;">
                                @if($course->start_time){{ date('h:i A', strtotime($course->start_time)) }}@endif
                                @if($course->start_time && $course->end_time) – @endif
                                @if($course->end_time){{ date('h:i A', strtotime($course->end_time)) }}@endif
                            </span>
                        </div>
                        @endif
                        @if($course->schedule_info)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Additional Notes</strong>
                            <span style="color: #888; font-size: 14px;">{{ $course->schedule_info }}</span>
                        </div>
                        @endif
                        @if($course->session_duration_minutes)
                        <div style="margin-bottom: 10px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Session Duration</strong>
                            <span style="color: #e0e0e0; font-size: 16px;">{{ intval($course->session_duration_minutes / 60) }}h {{ $course->session_duration_minutes % 60 }}m</span>
                        </div>
                        @endif
                    </div>
                    @endif
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Details</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Instructor</strong>
                        <a href="{{ route('admin.instructors.show', $course->instructor_id) }}" style="color: #4a9eff; font-size: 16px;">
                            {{ $course->instructor->name ?? 'N/A' }}
                        </a>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Credits</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->credits }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Fees</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;">${{ number_format($course->fees, 2) }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                        @if($course->is_active)
                            <span style="color: #6bff6b; font-size: 16px; font-weight: 600;">Active</span>
                        @else
                            <span style="color: #888; font-size: 16px; font-weight: 600;">Inactive</span>
                        @endif
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Created On</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->created_at->format('F d, Y h:i A') }}</span>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040; display: flex; gap: 15px;">
                <a href="{{ route('admin.courses.edit', $course->id) }}" class="btn btn-primary">Edit Course</a>
                <button type="button" onclick="openConfirmationModal('Delete Course', 'Are you sure you want to delete {{ addslashes($course->name) }}? This action cannot be undone and all associated data will be permanently removed.', '{{ route('admin.courses.destroy', $course->id) }}', 'DELETE')" class="btn btn-secondary" style="background: #dc3545; border: none;">
                    <i class="fas fa-trash"></i> Delete Course
                </button>
            </div>
        </div>
    </div>
    
    <!-- Course Chapters Section -->
    <div class="card" style="margin-top: 20px;">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>Course Curriculum ({{ $chapters->count() }} Chapters)</h3>
            <a href="{{ route('admin.courses.chapters.create', $course->id) }}" class="btn btn-primary">Add Chapter</a>
        </div>
        <div style="padding: 30px;">
            @if($chapters->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th style="width: 60px;">#</th>
                            <th>Chapter Title</th>
                            <th>Session</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($chapters as $chapter)
                            <tr>
                                <td><strong>{{ $chapter->chapter_number }}</strong></td>
                                <td>
                                    <strong style="color: #e0e0e0;">{{ $chapter->title }}</strong>
                                    @if($chapter->description)
                                        <div style="color: #888; font-size: 12px; margin-top: 5px;">{{ Str::limit($chapter->description, 100) }}</div>
                                    @endif
                                </td>
                                <td>
                                    @if($chapter->session_number)
                                        <span style="color: #4a9eff;">Session {{ $chapter->session_number }}</span>
                                    @else
                                        <span style="color: #888;">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    @if($chapter->is_published)
                                        <span style="color: #6bff6b;">Published</span>
                                    @else
                                        <span style="color: #888;">Draft</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.courses.chapters.show', [$course->id, $chapter->id]) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.courses.chapters.edit', [$course->id, $chapter->id]) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No chapters added yet.</p>
                    <a href="{{ route('admin.courses.chapters.create', $course->id) }}" class="btn btn-primary" style="margin-top: 15px;">Add First Chapter</a>
                </div>
            @endif
        </div>
    </div>
@endsection

