@extends('layouts.admin')

@section('title', 'Courses')
@section('page-title', 'Course Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Courses</h3>
            <a href="{{ route('admin.courses.create') }}" class="btn btn-primary">Add New Course</a>
        </div>
        
        <!-- Filters and Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.courses.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, code, or description..." 
                    value="{{ request('search') }}"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="instructor_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Instructors</option>
                    @foreach($instructors as $instructor)
                        <option value="{{ $instructor->id }}" {{ request('instructor_id') == $instructor->id ? 'selected' : '' }}>
                            {{ $instructor->name }}
                        </option>
                    @endforeach
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request()->anyFilled(['search', 'instructor_id', 'status']))
                    <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Courses Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($courses->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Course Name</th>
                            <th>Instructor</th>
                            <th>Credits</th>
                            <th>Fees</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($courses as $course)
                            <tr>
                                <td><strong>{{ $course->code }}</strong></td>
                                <td>{{ $course->name }}</td>
                                <td>{{ $course->instructor->name ?? 'N/A' }}</td>
                                <td>{{ $course->credits }}</td>
                                <td>${{ number_format($course->fees, 2) }}</td>
                                <td>
                                    @if($course->is_active)
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.courses.edit', $course->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Course', 'Are you sure you want to delete {{ addslashes($course->name) }}? This action cannot be undone.', '{{ route('admin.courses.destroy', $course->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $courses->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No courses found.</p>
                    <a href="{{ route('admin.courses.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Course</a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('styles')
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
@endsection

