@extends('layouts.admin')

@section('title', 'Add Course')
@section('page-title', 'Add New Course')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Create New Course</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.courses.store') }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="name">Course Name *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            value="{{ old('name') }}" 
                            required
                            autofocus
                            placeholder="e.g., Introduction to Programming"
                        >
                        @error('name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="code">Course Code *</label>
                        <input 
                            type="text" 
                            id="code" 
                            name="code" 
                            value="{{ old('code') }}" 
                            required
                            placeholder="e.g., CS101"
                        >
                        @error('code')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="instructor_id">Instructor *</label>
                        <select id="instructor_id" name="instructor_id" required>
                            <option value="">Select Instructor</option>
                            @foreach($instructors as $instructor)
                                <option value="{{ $instructor->id }}" {{ old('instructor_id') == $instructor->id ? 'selected' : '' }}>
                                    {{ $instructor->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('instructor_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="credits">Credits</label>
                        <input 
                            type="number" 
                            id="credits" 
                            name="credits" 
                            value="{{ old('credits', 0) }}" 
                            min="0"
                            placeholder="0"
                        >
                        @error('credits')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="fees">Fees</label>
                        <input 
                            type="number" 
                            id="fees" 
                            name="fees" 
                            value="{{ old('fees', 0.00) }}" 
                            step="0.01"
                            min="0"
                            placeholder="0.00"
                        >
                        @error('fees')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Course description"
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <!-- Academic Session Information -->
                <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px;">Academic Session Information</h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                        <div class="form-group">
                            <label for="academic_session">Academic Session</label>
                            <input 
                                type="text" 
                                id="academic_session" 
                                name="academic_session" 
                                value="{{ old('academic_session') }}" 
                                placeholder="e.g., Fall 2024"
                            >
                            @error('academic_session')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="from_month">From Month</label>
                            <select id="from_month" name="from_month">
                                <option value="">Select Month</option>
                                <option value="January" {{ old('from_month') == 'January' ? 'selected' : '' }}>January</option>
                                <option value="February" {{ old('from_month') == 'February' ? 'selected' : '' }}>February</option>
                                <option value="March" {{ old('from_month') == 'March' ? 'selected' : '' }}>March</option>
                                <option value="April" {{ old('from_month') == 'April' ? 'selected' : '' }}>April</option>
                                <option value="May" {{ old('from_month') == 'May' ? 'selected' : '' }}>May</option>
                                <option value="June" {{ old('from_month') == 'June' ? 'selected' : '' }}>June</option>
                                <option value="July" {{ old('from_month') == 'July' ? 'selected' : '' }}>July</option>
                                <option value="August" {{ old('from_month') == 'August' ? 'selected' : '' }}>August</option>
                                <option value="September" {{ old('from_month') == 'September' ? 'selected' : '' }}>September</option>
                                <option value="October" {{ old('from_month') == 'October' ? 'selected' : '' }}>October</option>
                                <option value="November" {{ old('from_month') == 'November' ? 'selected' : '' }}>November</option>
                                <option value="December" {{ old('from_month') == 'December' ? 'selected' : '' }}>December</option>
                            </select>
                            @error('from_month')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="to_month">To Month</label>
                            <select id="to_month" name="to_month">
                                <option value="">Select Month</option>
                                <option value="January" {{ old('to_month') == 'January' ? 'selected' : '' }}>January</option>
                                <option value="February" {{ old('to_month') == 'February' ? 'selected' : '' }}>February</option>
                                <option value="March" {{ old('to_month') == 'March' ? 'selected' : '' }}>March</option>
                                <option value="April" {{ old('to_month') == 'April' ? 'selected' : '' }}>April</option>
                                <option value="May" {{ old('to_month') == 'May' ? 'selected' : '' }}>May</option>
                                <option value="June" {{ old('to_month') == 'June' ? 'selected' : '' }}>June</option>
                                <option value="July" {{ old('to_month') == 'July' ? 'selected' : '' }}>July</option>
                                <option value="August" {{ old('to_month') == 'August' ? 'selected' : '' }}>August</option>
                                <option value="September" {{ old('to_month') == 'September' ? 'selected' : '' }}>September</option>
                                <option value="October" {{ old('to_month') == 'October' ? 'selected' : '' }}>October</option>
                                <option value="November" {{ old('to_month') == 'November' ? 'selected' : '' }}>November</option>
                                <option value="December" {{ old('to_month') == 'December' ? 'selected' : '' }}>December</option>
                            </select>
                            @error('to_month')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="number_of_weeks">Number of Weeks</label>
                            <input 
                                type="number" 
                                id="number_of_weeks" 
                                name="number_of_weeks" 
                                value="{{ old('number_of_weeks', 0) }}" 
                                min="0"
                                placeholder="e.g., 12"
                            >
                            @error('number_of_weeks')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="number_of_sessions">Number of Sessions</label>
                            <input 
                                type="number" 
                                id="number_of_sessions" 
                                name="number_of_sessions" 
                                value="{{ old('number_of_sessions', 0) }}" 
                                min="0"
                                placeholder="e.g., 24"
                            >
                            @error('number_of_sessions')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="session_duration_minutes">Session Duration (minutes)</label>
                            <input 
                                type="number" 
                                id="session_duration_minutes" 
                                name="session_duration_minutes" 
                                value="{{ old('session_duration_minutes', 90) }}" 
                                min="1"
                                placeholder="e.g., 90"
                            >
                            @error('session_duration_minutes')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <!-- Schedule Days and Time -->
                    <div style="margin-top: 20px;">
                        <h5 style="color: #4a9eff; margin-bottom: 15px;">Schedule Days & Time</h5>
                        
                        <div class="form-group">
                            <label>Select Days</label>
                            <div style="display: flex; flex-wrap: wrap; gap: 15px; padding: 15px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px;">
                                @php
                                    $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                                    $selectedDays = old('schedule_days', []);
                                @endphp
                                @foreach($days as $day)
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input 
                                            type="checkbox" 
                                            name="schedule_days[]" 
                                            value="{{ $day }}"
                                            style="margin-right: 8px; width: auto;"
                                            {{ in_array($day, $selectedDays) ? 'checked' : '' }}
                                        >
                                        <span style="color: #e0e0e0;">{{ $day }}</span>
                                    </label>
                                @endforeach
                            </div>
                            @error('schedule_days')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-top: 20px;">
                            <div class="form-group">
                                <label for="start_time">Start Time</label>
                                <select id="start_time" name="start_time">
                                    <option value="">Select Time</option>
                                    @for($hour = 6; $hour <= 22; $hour++)
                                        @foreach([0, 30] as $minute)
                                            @php
                                                $timeValue = str_pad($hour, 2, '0', STR_PAD_LEFT) . ':' . str_pad($minute, 2, '0', STR_PAD_LEFT);
                                                $timeDisplay = date('h:i A', strtotime($timeValue));
                                            @endphp
                                            <option value="{{ $timeValue }}" {{ old('start_time') == $timeValue ? 'selected' : '' }}>
                                                {{ $timeDisplay }}
                                            </option>
                                        @endforeach
                                    @endfor
                                </select>
                                @error('start_time')
                                    <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="end_time">End Time</label>
                                <select id="end_time" name="end_time">
                                    <option value="">Select Time</option>
                                    @for($hour = 6; $hour <= 22; $hour++)
                                        @foreach([0, 30] as $minute)
                                            @php
                                                $timeValue = str_pad($hour, 2, '0', STR_PAD_LEFT) . ':' . str_pad($minute, 2, '0', STR_PAD_LEFT);
                                                $timeDisplay = date('h:i A', strtotime($timeValue));
                                            @endphp
                                            <option value="{{ $timeValue }}" {{ old('end_time') == $timeValue ? 'selected' : '' }}>
                                                {{ $timeDisplay }}
                                            </option>
                                        @endforeach
                                    @endfor
                                </select>
                                @error('end_time')
                                    <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <!-- Keep schedule_info as optional fallback -->
                    <div class="form-group" style="margin-top: 20px;">
                        <label for="schedule_info">Additional Schedule Notes (Optional)</label>
                        <input 
                            type="text" 
                            id="schedule_info" 
                            name="schedule_info" 
                            value="{{ old('schedule_info') }}" 
                            placeholder="Additional schedule information"
                        >
                        @error('schedule_info')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 30px;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            name="is_active" 
                            value="1"
                            {{ old('is_active', true) ? 'checked' : '' }}
                            style="width: auto;"
                        >
                        <span>Active Course</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Create Course</button>
                    <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

