@extends('layouts.admin')

@section('title', 'Chapter Details')
@section('page-title', 'Chapter: ' . $chapter->title)

@section('content')
    <div style="display: flex; gap: 15px; margin-bottom: 20px;">
        <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary">← Back to Course</a>
        <a href="{{ route('admin.courses.chapters.edit', [$course->id, $chapter->id]) }}" class="btn btn-primary">Edit Chapter</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>Chapter {{ $chapter->chapter_number }}: {{ $chapter->title }}</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Chapter Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Chapter Number</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;">{{ $chapter->chapter_number }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Title</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $chapter->title }}</span>
                    </div>
                    @if($chapter->session_number)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Session</strong>
                        <span style="color: #4a9eff; font-size: 16px;">Session {{ $chapter->session_number }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                        @if($chapter->is_published)
                            <span style="color: #6bff6b; font-size: 16px; font-weight: 600;">Published</span>
                        @else
                            <span style="color: #888; font-size: 16px; font-weight: 600;">Draft</span>
                        @endif
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Created On</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $chapter->created_at->format('F d, Y h:i A') }}</span>
                    </div>
                </div>
            </div>
            
            @if($chapter->description)
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Description</h4>
                <p style="color: #e0e0e0; line-height: 1.6;">{{ $chapter->description }}</p>
            </div>
            @endif
            
            @if($chapter->content)
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Chapter Content</h4>
                <div style="color: #e0e0e0; line-height: 1.6; white-space: pre-wrap;">{{ $chapter->content }}</div>
            </div>
            @endif
            
            <!-- Action Buttons -->
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040; display: flex; gap: 15px;">
                <a href="{{ route('admin.courses.chapters.edit', [$course->id, $chapter->id]) }}" class="btn btn-primary">Edit Chapter</a>
                <button type="button" onclick="openConfirmationModal('Delete Chapter', 'Are you sure you want to delete {{ addslashes($chapter->title) }}? This action cannot be undone.', '{{ route('admin.courses.chapters.destroy', [$course->id, $chapter->id]) }}', 'DELETE')" class="btn btn-secondary" style="background: #dc3545; border: none;">
                    <i class="fas fa-trash"></i> Delete Chapter
                </button>
            </div>
        </div>
    </div>
@endsection


