@extends('layouts.admin')

@section('title', 'Add Chapter')
@section('page-title', 'Add Chapter to: ' . $course->name)

@section('content')
    <div style="display: flex; gap: 15px; margin-bottom: 20px;">
        <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary">← Back to Course</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>Create New Chapter</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.courses.chapters.store', $course->id) }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="chapter_number">Chapter Number *</label>
                        <input 
                            type="number" 
                            id="chapter_number" 
                            name="chapter_number" 
                            value="{{ old('chapter_number', $nextChapterNumber) }}" 
                            required
                            min="1"
                            placeholder="1"
                        >
                        @error('chapter_number')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="session_number">Session Number</label>
                        <input 
                            type="number" 
                            id="session_number" 
                            name="session_number" 
                            value="{{ old('session_number') }}" 
                            min="1"
                            max="{{ $course->number_of_sessions ?? 999 }}"
                            placeholder="Which session"
                        >
                        @error('session_number')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="order">Display Order</label>
                        <input 
                            type="number" 
                            id="order" 
                            name="order" 
                            value="{{ old('order', $nextChapterNumber) }}" 
                            min="0"
                            placeholder="Display order"
                        >
                        @error('order')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="title">Chapter Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="{{ old('title') }}" 
                        required
                        autofocus
                        placeholder="e.g., Chapter 1: Getting Started with Flutter and Dart"
                    >
                    @error('title')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="3"
                        placeholder="Brief description of the chapter"
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="content">Chapter Content</label>
                    <textarea 
                        id="content" 
                        name="content" 
                        rows="10"
                        placeholder="Detailed chapter content (can include lesson plans, objectives, etc.)"
                    >{{ old('content') }}</textarea>
                    @error('content')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            name="is_published" 
                            value="1"
                            {{ old('is_published') ? 'checked' : '' }}
                            style="width: auto;"
                        >
                        <span>Publish Chapter (visible to students)</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Create Chapter</button>
                    <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection


