@extends('layouts.admin')

@section('title', 'Course Offering Details')
@section('page-title', 'Course Offering Details')

@section('content')
    <div style="display: flex; gap: 20px; flex-wrap: wrap;">
        <!-- Main Details Card -->
        <div class="card" style="flex: 2; min-width: 300px;">
            <div class="card-header">
                <h3>{{ $offering->name }}</h3>
                <div style="margin-top: 10px; display: flex; gap: 10px; align-items: center;">
                    @if($offering->status == 'active')
                        <span style="color: #6bff6b; font-weight: bold;">● Active</span>
                    @elseif($offering->status == 'upcoming')
                        <span style="color: #4a9eff; font-weight: bold;">● Upcoming</span>
                    @elseif($offering->status == 'completed')
                        <span style="color: #888; font-weight: bold;">● Completed</span>
                    @else
                        <span style="color: #ff6b6b; font-weight: bold;">● Cancelled</span>
                    @endif
                    <a href="{{ route('admin.course-offerings.edit', $offering->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; margin-left: auto;">Edit</a>
                </div>
            </div>
            
            <div style="padding: 30px;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px;">
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <p style="font-size: 16px;">{{ $offering->course->name }} ({{ $offering->course->code }})</p>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Start Date</strong>
                        <p style="font-size: 16px;">{{ $offering->start_date->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">End Date</strong>
                        <p style="font-size: 16px;">{{ $offering->end_date->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Students</strong>
                        <p style="font-size: 16px;">{{ $offering->current_students }} / {{ $offering->max_students > 0 ? $offering->max_students : '∞' }}</p>
                    </div>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Enrollment Period</strong>
                        <p style="font-size: 16px;">{{ $offering->enrollment_start_date->format('M d') }} - {{ $offering->enrollment_end_date->format('M d, Y') }}</p>
                    </div>
                </div>
                
                <div style="border-top: 1px solid #404040; padding-top: 20px; margin-top: 20px;">
                    <h4 style="margin-bottom: 15px;">Finance Summary</h4>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                        <div style="background: #2d2d2d; padding: 15px; border-radius: 5px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Total Fees</strong>
                            <p style="font-size: 18px; font-weight: bold; color: #4a9eff;">₵{{ number_format($totalFees, 2) }}</p>
                        </div>
                        <div style="background: #2d2d2d; padding: 15px; border-radius: 5px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Paid</strong>
                            <p style="font-size: 18px; font-weight: bold; color: #6bff6b;">₵{{ number_format($paidFees, 2) }}</p>
                        </div>
                        <div style="background: #2d2d2d; padding: 15px; border-radius: 5px;">
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Balance</strong>
                            <p style="font-size: 18px; font-weight: bold; color: #ff6b6b;">₵{{ number_format($totalFees - $paidFees, 2) }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Student Fees Table -->
    <div class="card" style="margin-top: 20px;">
        <div class="card-header">
            <h3>Student Fees & Payments</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if(count($studentFeesData) > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>School ID</th>
                            <th>Course Fee</th>
                            <th>Paid</th>
                            <th>Balance</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($studentFeesData as $data)
                            <tr>
                                <td><strong>{{ $data['student']->name }}</strong></td>
                                <td>{{ $data['student']->school_id ?? 'N/A' }}</td>
                                <td>₵{{ number_format($data['course_fee'], 2) }}</td>
                                <td style="color: #6bff6b;">₵{{ number_format($data['paid'], 2) }}</td>
                                <td style="color: {{ $data['balance'] > 0 ? '#ff6b6b' : '#6bff6b' }};">₵{{ number_format($data['balance'], 2) }}</td>
                                <td>
                                    @if($data['balance'] <= 0)
                                        <span style="color: #6bff6b;">Paid</span>
                                    @elseif($data['paid'] > 0)
                                        <span style="color: #ffa500;">Partial</span>
                                    @else
                                        <span style="color: #ff6b6b;">Pending</span>
                                    @endif
                                </td>
                                <td>
                                    <button onclick="openPaymentModal({{ $data['student']->id }}, '{{ addslashes($data['student']->name) }}', {{ $offering->course->id }}, '{{ addslashes($offering->course->name) }}', {{ $data['course_fee'] }}, {{ $data['paid'] }}, {{ $data['balance'] }}, {{ $offering->id }})" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        Record Payment
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No students enrolled in this offering yet.</p>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Payment History -->
    <div class="card" style="margin-top: 20px;">
        <div class="card-header">
            <h3>Payment History</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($feePayments->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Student</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Reference</th>
                            <th>Recorded By</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($feePayments as $payment)
                            <tr>
                                <td>{{ $payment->payment_date->format('M d, Y') }}</td>
                                <td><strong>{{ $payment->student->name }}</strong></td>
                                <td style="color: #6bff6b;">₵{{ number_format($payment->amount, 2) }}</td>
                                <td>{{ ucfirst(str_replace('_', ' ', $payment->payment_method)) }}</td>
                                <td>{{ $payment->transaction_reference ?? 'N/A' }}</td>
                                <td>{{ $payment->recordedBy->name }}</td>
                                <td>{{ $payment->notes ?? '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <div style="margin-top: 20px;">
                    {{ $feePayments->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No payments recorded yet.</p>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Payment Modal -->
    <div id="paymentModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: #2d2d2d; padding: 30px; border-radius: 10px; max-width: 500px; width: 90%; max-height: 90vh; overflow-y: auto;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h3>Record Payment</h3>
                <button onclick="closePaymentModal()" style="background: none; border: none; color: #e0e0e0; font-size: 24px; cursor: pointer;"><i class="fas fa-times"></i></button>
            </div>
            
            <form id="paymentForm" method="POST" action="{{ route('admin.fee-payments.store') }}">
                @csrf
                <input type="hidden" name="course_offering_id" value="{{ $offering->id }}">
                <input type="hidden" id="course_id" name="course_id" value="{{ $offering->course_id }}">
                <input type="hidden" id="student_id" name="student_id">
                
                <div style="margin-bottom: 20px; padding: 15px; background: #1a1a1a; border-radius: 5px;">
                    <strong>Student:</strong> <span id="student_name"></span><br>
                    <strong>Course:</strong> <span id="course_name"></span><br>
                    <strong>Course Fee:</strong> ₵<span id="course_fee"></span><br>
                    <strong>Already Paid:</strong> ₵<span id="already_paid"></span><br>
                    <strong>Balance:</strong> ₵<span id="balance"></span>
                </div>
                
                <div class="form-group">
                    <label for="amount">Payment Amount *</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="payment_date">Payment Date *</label>
                    <input type="date" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}" required>
                </div>
                
                <div class="form-group">
                    <label for="payment_method">Payment Method *</label>
                    <select id="payment_method" name="payment_method" required>
                        <option value="cash">Cash</option>
                        <option value="bank_transfer">Bank Transfer</option>
                        <option value="card">Card</option>
                        <option value="online">Online</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="payment_status">Payment Status *</label>
                    <select id="payment_status" name="payment_status" required>
                        <option value="regular">Regular Payment</option>
                        <option value="scholarship">Scholarship</option>
                        <option value="refunded">Refunded</option>
                    </select>
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Scholarship and Refunded payments don't count toward actual money at hand.
                    </small>
                </div>
                
                <div class="form-group">
                    <label for="transaction_reference">Transaction Reference</label>
                    <input type="text" id="transaction_reference" name="transaction_reference">
                </div>
                
                <div class="form-group">
                    <label for="notes">Notes</label>
                    <textarea id="notes" name="notes" rows="3"></textarea>
                </div>
                
                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Record Payment</button>
                    <button type="button" onclick="closePaymentModal()" class="btn btn-secondary">Cancel</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function openPaymentModal(studentId, studentName, courseId, courseName, courseFee, alreadyPaid, balance, offeringId) {
        document.getElementById('student_id').value = studentId;
        document.getElementById('course_id').value = courseId;
        document.getElementById('student_name').textContent = studentName;
        document.getElementById('course_name').textContent = courseName;
        document.getElementById('course_fee').textContent = parseFloat(courseFee).toFixed(2);
        document.getElementById('already_paid').textContent = parseFloat(alreadyPaid).toFixed(2);
        document.getElementById('balance').textContent = parseFloat(balance).toFixed(2);
        document.getElementById('amount').max = balance;
        document.getElementById('paymentModal').style.display = 'flex';
    }
    
    function closePaymentModal() {
        document.getElementById('paymentModal').style.display = 'none';
        document.getElementById('paymentForm').reset();
    }
    
    // Close modal when clicking outside
    document.getElementById('paymentModal')?.addEventListener('click', function(e) {
        if (e.target === this) {
            closePaymentModal();
        }
    });
</script>
@endpush

