@extends('layouts.admin')

@section('title', 'Course Offerings')
@section('page-title', 'Course Offerings Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Course Offerings</h3>
            <a href="{{ route('admin.course-offerings.create') }}" class="btn btn-primary">Add New Offering</a>
        </div>
        
        <!-- Filters and Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.course-offerings.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name or course..." 
                    value="{{ request('search') }}"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                            {{ $course->name }}
                        </option>
                    @endforeach
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="upcoming" {{ request('status') == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request()->anyFilled(['search', 'course_id', 'status']))
                    <a href="{{ route('admin.course-offerings.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Course Offerings Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($offerings->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Offering Name</th>
                            <th>Course</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Students</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($offerings as $offering)
                            <tr>
                                <td><strong>{{ $offering->name }}</strong></td>
                                <td>{{ $offering->course->name }} ({{ $offering->course->code }})</td>
                                <td>{{ $offering->start_date->format('M d, Y') }}</td>
                                <td>{{ $offering->end_date->format('M d, Y') }}</td>
                                <td>{{ $offering->current_students }} / {{ $offering->max_students > 0 ? $offering->max_students : '∞' }}</td>
                                <td>
                                    @if($offering->status == 'active')
                                        <span style="color: #6bff6b;">Active</span>
                                    @elseif($offering->status == 'upcoming')
                                        <span style="color: #4a9eff;">Upcoming</span>
                                    @elseif($offering->status == 'completed')
                                        <span style="color: #888;">Completed</span>
                                    @else
                                        <span style="color: #ff6b6b;">Cancelled</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.course-offerings.show', $offering->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.course-offerings.edit', $offering->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Course Offering', 'Are you sure you want to delete {{ addslashes($offering->name) }}? This action cannot be undone.', '{{ route('admin.course-offerings.destroy', $offering->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $offerings->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No course offerings found.</p>
                    <a href="{{ route('admin.course-offerings.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Offering</a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('styles')
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
@endsection

