@extends('layouts.admin')

@section('title', 'Edit Course Offering')
@section('page-title', 'Edit Course Offering')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Course Offering</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.course-offerings.update', $offering->id) }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required>
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ (old('course_id', $offering->course_id) == $course->id) ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="name">Offering Name *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            value="{{ old('name', $offering->name) }}" 
                            required
                            autofocus
                            placeholder="e.g., Fall 2024, Spring 2025"
                        >
                        @error('name')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="max_students">Max Students</label>
                        <input 
                            type="number" 
                            id="max_students" 
                            name="max_students" 
                            value="{{ old('max_students', $offering->max_students) }}" 
                            min="0"
                            placeholder="0 for unlimited"
                        >
                        @error('max_students')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="start_date">Start Date *</label>
                        <input 
                            type="date" 
                            id="start_date" 
                            name="start_date" 
                            value="{{ old('start_date', $offering->start_date->format('Y-m-d')) }}" 
                            required
                        >
                        @error('start_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="end_date">End Date *</label>
                        <input 
                            type="date" 
                            id="end_date" 
                            name="end_date" 
                            value="{{ old('end_date', $offering->end_date->format('Y-m-d')) }}" 
                            required
                        >
                        @error('end_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="enrollment_start_date">Enrollment Start Date *</label>
                        <input 
                            type="date" 
                            id="enrollment_start_date" 
                            name="enrollment_start_date" 
                            value="{{ old('enrollment_start_date', $offering->enrollment_start_date->format('Y-m-d')) }}" 
                            required
                        >
                        @error('enrollment_start_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="enrollment_end_date">Enrollment End Date *</label>
                        <input 
                            type="date" 
                            id="enrollment_end_date" 
                            name="enrollment_end_date" 
                            value="{{ old('enrollment_end_date', $offering->enrollment_end_date->format('Y-m-d')) }}" 
                            required
                        >
                        @error('enrollment_end_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="status">Status *</label>
                    <select id="status" name="status" required>
                        <option value="upcoming" {{ old('status', $offering->status) == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                        <option value="active" {{ old('status', $offering->status) == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="completed" {{ old('status', $offering->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="cancelled" {{ old('status', $offering->status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                    @error('status')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Update Offering</button>
                    <a href="{{ route('admin.course-offerings.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

